/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.UriParameter;
import raml.tools.model.ActionContext;

public class ResourceContext {
    Resource resource;

    public ResourceContext(Resource resource) {
        this.resource = resource;
    }

    public String getUniqueId() {
        return DigestUtils.md5Hex((String)(this.getParentUrl() + this.getRelativeUri()));
    }

    public List<ResourceContext> getResources() {
        ArrayList<ResourceContext> arrayList = new ArrayList<ResourceContext>();
        for (Resource resource : this.resource.getResources().values()) {
            arrayList.add(new ResourceContext(resource));
        }
        return arrayList;
    }

    public String getType() {
        return this.resource.getType();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.resource.getUriParameters();
    }

    public Collection<ActionContext> getActions() {
        ArrayList<ActionContext> arrayList = new ArrayList<ActionContext>();
        for (Action action : this.resource.getActions().values()) {
            arrayList.add(new ActionContext(action));
        }
        return arrayList;
    }

    public String getRelativeUri() {
        return this.resource.getRelativeUri();
    }

    public String getParentUrl() {
        return this.resource.getParentUri();
    }

    public Action getAction(String string) {
        return this.resource.getAction(string);
    }

    public Resource getResource(String string) {
        return this.resource.getResource(string);
    }

    public String getUri() {
        return this.resource.getUri();
    }

    public List<SecurityReference> getSecuredBy() {
        return this.resource.getSecuredBy();
    }

    public Action getAction(ActionType actionType) {
        return this.resource.getAction(actionType);
    }

    public List<String> getIs() {
        return this.resource.getIs();
    }

    public Map<String, List<UriParameter>> getBaseUriParameters() {
        return this.resource.getBaseUriParameters();
    }
}

