/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.html;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.MarkdownHelper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import org.raml.model.Raml;
import raml.tools.AbstractGenerator;
import raml.tools.IoUtil;
import raml.tools.html.HandlebarsHelper;
import raml.tools.html.HtmlGeneratorBuilder;
import raml.tools.model.RamlContext;

public class HtmlGenerator
extends AbstractGenerator {
    final Handlebars handlebars;
    private final IoUtil io;
    private String templateLocation;
    private String output = "";

    public HtmlGenerator(String string, IoUtil ioUtil) {
        this.io = ioUtil;
        this.templateLocation = string;
        this.handlebars = this.withHelpers(this.createHandleBars());
    }

    Handlebars createHandleBars() {
        Handlebars handlebars = new Handlebars();
        handlebars.setInfiniteLoops(true);
        return handlebars;
    }

    private Handlebars withHelpers(Handlebars handlebars) {
        handlebars.registerHelper("md", (Helper)new MarkdownHelper());
        handlebars.registerHelper("lower", HandlebarsHelper.lowerCaseHelper());
        handlebars.registerHelper("lock", HandlebarsHelper.lockHelper());
        handlebars.registerHelper("highlight", HandlebarsHelper.highlitghHelper());
        return handlebars;
    }

    @Override
    public void startTraversal(Raml raml) {
        try {
            Template template = this.handlebars.compile((TemplateSource)new StringTemplateSource(this.templateLocation, this.io.contentFromFile(this.templateLocation)));
            this.output = template.apply((Object)new RamlContext(raml));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static HtmlGeneratorBuilder build() {
        return new HtmlGeneratorBuilder();
    }

    public String getOutput() {
        return this.output;
    }
}

