/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.raml.model.Raml;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;

public class RamlParser {
    public Raml parseRaml(InputStream ramlStream) {
        return (Raml)new RamlDocumentBuilder().build(ramlStream);
    }

    public Raml parseRaml(String basePath, InputStream ramlStream) {
        if (basePath == null) {
            return this.parseRaml(ramlStream);
        }
        return (Raml)new RamlDocumentBuilder((ResourceLoader)RamlParser.basePathLoader(basePath), new TagResolver[0]).build(ramlStream);
    }

    public static DefaultResourceLoader basePathLoader(final String basePath) {
        return new DefaultResourceLoader(){

            public InputStream fetchResource(String resourceName) {
                if (basePath == null) {
                    return super.fetchResource(resourceName);
                }
                File ramlFileAtBasePath = new File(basePath + File.separatorChar + resourceName);
                if (ramlFileAtBasePath.exists()) {
                    return this.getFileInputStream(ramlFileAtBasePath);
                }
                return super.fetchResource(resourceName);
            }

            private InputStream getFileInputStream(File ramlFileAtBasePath) {
                try {
                    return new FileInputStream(ramlFileAtBasePath);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

