/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import raml.tools.handlebars.HandlebarsFactory;
import raml.tools.html.Raml2HtmlRenderer;
import raml.tools.model.RamlContext;
import raml.tools.util.RamlParser;

public class Raml2HtmlConverter {
    String ramlBasePath = null;
    String mainTemplate = null;

    public void convert(String ramlFilePath, String outputFilePath) {
        try {
            this.convert(new FileInputStream(new File(ramlFilePath)), new FileOutputStream(new File(outputFilePath)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends OutputStream> T convert(InputStream ramlFilePath, T outputStream) {
        try {
            String ramlHtml = new Raml2HtmlRenderer(new RamlContext(new RamlParser().parseRaml(this.ramlBasePath, ramlFilePath)), HandlebarsFactory.defaultHandlebars()).renderFull(this.mainTemplate);
            outputStream.write(ramlHtml.getBytes());
            T t = outputStream;
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Raml2HtmlConverter withMainTemplate(String mainTemplate) {
        this.mainTemplate = mainTemplate;
        return this;
    }

    public Raml2HtmlConverter withRamlBasePath(String ramlBasePath) {
        this.ramlBasePath = ramlBasePath;
        return this;
    }
}

