/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.dsl;

import de.androbit.nibbler.dsl.HandlerDefinition;
import de.androbit.nibbler.http.RestHttpMethod;
import de.androbit.nibbler.http.RestRequestHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathDefinition {
    final String pathTemplate;
    Map<RestHttpMethod, List<HandlerDefinition>> methodHandlers = new HashMap<RestHttpMethod, List<HandlerDefinition>>();

    public PathDefinition(String pathTemplate) {
        this.pathTemplate = pathTemplate;
    }

    public PathDefinition get(RestRequestHandler handler) {
        return this.get(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition get(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.GET));
    }

    public PathDefinition post(RestRequestHandler handler) {
        return this.post(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition post(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.POST));
    }

    public PathDefinition put(RestRequestHandler handler) {
        return this.put(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition put(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.PUT));
    }

    public PathDefinition delete(RestRequestHandler handler) {
        return this.delete(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition delete(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.DELETE));
    }

    public PathDefinition patch(RestRequestHandler handler) {
        return this.patch(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition patch(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.PATCH));
    }

    public PathDefinition head(RestRequestHandler handler) {
        return this.head(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition head(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.HEAD));
    }

    public PathDefinition options(RestRequestHandler handler) {
        return this.options(new HandlerDefinition().withRequestHandler(handler));
    }

    public PathDefinition options(HandlerDefinition handler) {
        return this.addHandler(handler.withHttpMethod(RestHttpMethod.OPTIONS));
    }

    protected PathDefinition addHandler(HandlerDefinition handlerDefinition) {
        List<HandlerDefinition> methodHandlers = this.getOrCreateMethodHandlerList(handlerDefinition.getRestHttpMethod());
        methodHandlers.add(handlerDefinition);
        return this;
    }

    protected List<HandlerDefinition> getOrCreateMethodHandlerList(RestHttpMethod restHttpMethod) {
        if (this.methodHandlers.get((Object)restHttpMethod) == null) {
            this.methodHandlers.put(restHttpMethod, new ArrayList());
        }
        return this.methodHandlers.get((Object)restHttpMethod);
    }

    public Map<RestHttpMethod, List<HandlerDefinition>> getMethodHandlers() {
        return this.methodHandlers;
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    public String toString() {
        return "PathDefinition{pathTemplate='" + this.pathTemplate + '\'' + ", methodHandlers=" + this.methodHandlers + '}';
    }
}

