/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler;

import de.androbit.nibbler.RestService;
import de.androbit.nibbler.RestServiceBuilder;
import de.androbit.nibbler.converter.ContentConverter;
import de.androbit.nibbler.converter.ContentConverters;
import de.androbit.nibbler.converter.StringConverter;
import de.androbit.nibbler.http.MediaType;
import java.util.ArrayList;
import java.util.List;

public class RestHttpServerConfiguration {
    int port = 8080;
    String interfaceName = "0.0.0.0";
    int requestProcessingThreads = 50;
    List<RestService> restServices = new ArrayList<RestService>();
    ContentConverters converters = new ContentConverters(new StringConverter());

    public int getPort() {
        return this.port;
    }

    public RestHttpServerConfiguration withPort(int port) {
        this.port = port;
        return this;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public RestHttpServerConfiguration withInterface(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    public int getRequestProcessingThreads() {
        return this.requestProcessingThreads;
    }

    public List<RestService> getRestServices() {
        return this.restServices;
    }

    public ContentConverters getConverters() {
        return this.converters;
    }

    public RestHttpServerConfiguration withRequestProcessingThreads(int requestProcessingThreads) {
        this.requestProcessingThreads = requestProcessingThreads;
        return this;
    }

    public RestHttpServerConfiguration withService(RestServiceBuilder restService) {
        this.restServices.add(restService.build());
        return this;
    }

    public RestHttpServerConfiguration withConverter(ContentConverter converter) {
        this.converters.setDefaultConverter(converter);
        return this;
    }

    public RestHttpServerConfiguration withTypeConverter(MediaType mediaType, ContentConverter converter) {
        this.converters.addConverter(mediaType, converter);
        return this;
    }
}

