/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.http;

import de.androbit.nibbler.dsl.HandlerDefinition;
import de.androbit.nibbler.dsl.PathDefinition;
import de.androbit.nibbler.http.FoundHandlerDefinition;
import de.androbit.nibbler.http.Header;
import de.androbit.nibbler.http.RestHttpMethod;
import de.androbit.nibbler.http.RestRequest;
import de.androbit.nibbler.http.uri.PathMatchResult;
import de.androbit.nibbler.http.uri.PathMatcher;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RequestHandlerMatcher {
    List<PathDefinition> pathDefinitions;
    PathMatcher pathMatcher = new PathMatcher();

    public RequestHandlerMatcher(List<PathDefinition> pathDefinitions) {
        this.pathDefinitions = pathDefinitions;
    }

    public MatchingHandlers getMatchingHandlers(RestRequest request) {
        Optional<String> acceptHeader = Optional.ofNullable(request.header(Header.Accept.getName()));
        List<MatchingPathDefinition> matchingPathHandlers = this.getPathHandlers(request.path().value()).collect(Collectors.toList());
        List<FoundHandlerDefinition> methodHandlers = matchingPathHandlers.stream().flatMap(this.matchingMethodHandlers(request.method())).collect(Collectors.toList());
        Optional<FoundHandlerDefinition> contentHandler = this.getHandlerForContentType(acceptHeader, methodHandlers);
        return new MatchingHandlers(matchingPathHandlers, methodHandlers, contentHandler);
    }

    Function<MatchingPathDefinition, Stream<? extends FoundHandlerDefinition>> matchingMethodHandlers(RestHttpMethod restHttpMethod) {
        return pathDefinition -> pathDefinition.getPathDefinition().getMethodHandlers().get((Object)restHttpMethod).stream().filter(this.handlerWithMethod(restHttpMethod)).flatMap(handlerDefinition -> Stream.of(new FoundHandlerDefinition(pathDefinition.getMatchResult(), (HandlerDefinition)handlerDefinition)));
    }

    Predicate<HandlerDefinition> handlerWithMethod(RestHttpMethod httpMethod) {
        return handlerDefinition -> handlerDefinition.getRestHttpMethod() == httpMethod;
    }

    private Optional<FoundHandlerDefinition> getHandlerForContentType(Optional<String> acceptHeader, List<FoundHandlerDefinition> methodHandlers) {
        Stream<FoundHandlerDefinition> contentHandlers = methodHandlers.stream().filter(handler -> !acceptHeader.isPresent() || this.allTypesAccepted(acceptHeader) || this.handlerAccepts(acceptHeader, handler.getHandlerDefinition()));
        return contentHandlers.findFirst();
    }

    private boolean allTypesAccepted(Optional<String> acceptHeader) {
        return acceptHeader.get().contains("*/*");
    }

    private boolean handlerAccepts(Optional<String> acceptHeader, HandlerDefinition handler) {
        return handler.getHandledType().isPresent() && acceptHeader.get().contains(handler.getHandledType().get().contentType());
    }

    private Stream<MatchingPathDefinition> getPathHandlers(String requestPath) {
        return this.pathDefinitions.stream().flatMap(path -> {
            PathMatchResult matchResult = this.pathMatcher.match(path.getPathTemplate(), requestPath);
            if (matchResult.isMatch()) {
                return Stream.of(new MatchingPathDefinition((PathDefinition)path, matchResult));
            }
            return Stream.empty();
        });
    }

    class MatchingPathDefinition {
        PathDefinition pathDefinition;
        PathMatchResult matchResult;

        MatchingPathDefinition(PathDefinition pathDefinition, PathMatchResult matchResult) {
            this.pathDefinition = pathDefinition;
            this.matchResult = matchResult;
        }

        public PathDefinition getPathDefinition() {
            return this.pathDefinition;
        }

        public PathMatchResult getMatchResult() {
            return this.matchResult;
        }
    }

    public static class MatchingHandlers {
        private List<MatchingPathDefinition> matchingPathHandlers;
        List<FoundHandlerDefinition> methodHandlers;
        Optional<FoundHandlerDefinition> contentHandler;

        public MatchingHandlers(List<MatchingPathDefinition> matchingPathHandlers, List<FoundHandlerDefinition> methodHandlers, Optional<FoundHandlerDefinition> contentHandler) {
            this.matchingPathHandlers = matchingPathHandlers;
            this.methodHandlers = methodHandlers;
            this.contentHandler = contentHandler;
        }

        public List<MatchingPathDefinition> getMatchingPathHandlers() {
            return this.matchingPathHandlers;
        }

        public List<FoundHandlerDefinition> getMethodHandlers() {
            return this.methodHandlers;
        }

        public Optional<FoundHandlerDefinition> getContentHandler() {
            return this.contentHandler;
        }
    }
}

