/*
 * Decompiled with CFR 0.152.
 */
package brainslug.spring;

import brainslug.flow.context.BrainslugContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.Environment;

public class SpringBrainslugLifecycle
implements SmartLifecycle {
    AtomicBoolean started = new AtomicBoolean(false);
    @Autowired
    BrainslugContext brainslugContext;
    @Autowired
    Environment environment;

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        Boolean schedulersEnabled = (Boolean)this.environment.getProperty("brainslug.schedulers.enabled", Boolean.class, (Object)true);
        if (schedulersEnabled.booleanValue() && !this.started.get()) {
            this.brainslugContext.init();
            this.started.set(true);
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.brainslugContext.destroy();
            this.started.set(false);
        }
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public int getPhase() {
        return 0;
    }
}

