/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.renderer;

import brainslug.flow.model.ChoiceDefinition;
import brainslug.flow.model.FlowBuilder;
import brainslug.flow.model.FlowEdgeDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.ThenDefinition;
import brainslug.flow.renderer.Format;
import brainslug.flow.renderer.Renderer;
import brainslug.flow.renderer.Skin;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class JGraphRenderer
implements Renderer {
    public static final int INTER_RANK_CELL_SPACING = 75;
    private final Skin skin;
    double scale = 1.0;
    int padding = 20;

    public JGraphRenderer(Skin skin) {
        this.skin = skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private mxGraph createGraph(FlowBuilder flowBuilder) {
        mxGraph graph = this.skin.apply(new mxGraph());
        graph.getModel().beginUpdate();
        try {
            this.convertFlowToGraph(flowBuilder, graph);
            mxHierarchicalLayout layout = new mxHierarchicalLayout(graph, 7);
            layout.setInterRankCellSpacing(75.0);
            layout.execute(graph.getDefaultParent());
        }
        finally {
            graph.getModel().endUpdate();
        }
        return graph;
    }

    private void convertFlowToGraph(FlowBuilder flowBuilder, mxGraph graph) {
        ArrayList<FlowEdgeDefinition> edges = new ArrayList<FlowEdgeDefinition>();
        HashMap<String, Object> vertices = new HashMap<String, Object>();
        for (FlowNodeDefinition node : flowBuilder.getDefinition().getNodes()) {
            mxRectangle size = this.skin.getNodeSize(node);
            Object vertex = graph.insertVertex(graph.getDefaultParent(), node.getId().stringValue(), (Object)node.getDisplayName(), 0.0, 0.0, size.getWidth(), size.getHeight());
            vertices.put(node.getId().toString(), vertex);
            this.collectNodeEdges(edges, node);
            graph.setCellStyle(this.skin.getShape(node), new Object[]{vertex});
        }
        this.addEdgesToGraph(edges, vertices, graph);
    }

    private void addEdgesToGraph(List<FlowEdgeDefinition> edges, Map<String, Object> vertices, mxGraph graph) {
        for (FlowEdgeDefinition edge : edges) {
            Object source = vertices.get(edge.getSource().getId().toString());
            Object target = vertices.get(edge.getTarget().getId().toString());
            graph.insertEdge(graph.getDefaultParent(), null, (Object)this.getEdgeLabel(edge), source, target);
        }
    }

    private String getEdgeLabel(FlowEdgeDefinition edge) {
        String label = edge.getDisplayName();
        if (edge.getSource() instanceof ChoiceDefinition) {
            for (ThenDefinition then : ((ChoiceDefinition)edge.getSource()).getThenPaths()) {
                if (!((FlowNodeDefinition)then.getPathNodes().get(1)).equals((Object)edge.getTarget())) continue;
                return then.getPredicateDefinition().getActual().toString();
            }
        }
        return label;
    }

    private void collectNodeEdges(List<FlowEdgeDefinition> edges, FlowNodeDefinition<?> node) {
        for (FlowEdgeDefinition edge : node.getOutgoing()) {
            edges.add(edge);
        }
    }

    private mxRectangle getScaledGraphBounds(mxGraph graph, double scale, int padding) {
        mxRectangle bounds = graph.getGraphBounds();
        bounds.setWidth(bounds.getWidth() * scale);
        bounds.setHeight(bounds.getHeight() * scale);
        bounds.grow((double)padding);
        return bounds;
    }

    @Override
    public void render(FlowBuilder flowBuilder, OutputStream outputStream, Format format) {
        mxGraph graph = this.createGraph(flowBuilder);
        mxRectangle bounds = this.getScaledGraphBounds(graph, this.scale, this.padding);
        BufferedImage img = mxCellRenderer.createBufferedImage((mxGraph)graph, (Object[])graph.getChildCells(graph.getModel().getRoot()), (double)this.scale, null, (boolean)false, (mxRectangle)bounds);
        this.save(img, format, outputStream);
    }

    private void save(BufferedImage image, Format format, OutputStream outputStream) {
        try {
            ImageIO.write(this.prepareImage(image, format), format.name().toLowerCase(), outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RenderedImage prepareImage(BufferedImage image, Format format) {
        if (format == Format.JPG) {
            return this.convertType(image);
        }
        return image;
    }

    private RenderedImage convertType(BufferedImage source) {
        BufferedImage convertedImage = new BufferedImage(source.getWidth(), source.getHeight(), 5);
        convertedImage.getGraphics().setColor(Color.white);
        convertedImage.getGraphics().fillRect(0, 0, source.getWidth(), source.getHeight());
        convertedImage.getGraphics().drawImage(source, 0, 0, null);
        return convertedImage;
    }
}

