/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.model;

import brainslug.flow.model.AbstractTaskDefinition;
import brainslug.flow.model.EnumIdentifier;
import brainslug.flow.model.EventDefinition;
import brainslug.flow.model.FlowDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.FlowPathDefinition;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.JoinDefinition;
import brainslug.flow.model.MergeDefinition;
import brainslug.flow.model.MethodCallDefinition;
import brainslug.flow.model.StringIdentifier;
import brainslug.flow.model.TaskDefinition;
import brainslug.flow.model.expression.Constant;
import brainslug.flow.model.expression.Expression;
import brainslug.flow.model.expression.PredicateBuilder;
import brainslug.flow.model.marker.StartEvent;
import java.util.Arrays;
import java.util.List;

public class FlowBuilderSupport {
    protected FlowDefinition definition;

    public FlowBuilderSupport(FlowDefinition definition) {
        this.definition = definition;
    }

    public Identifier id(Enum id) {
        return new EnumIdentifier(id);
    }

    public Identifier id(String id) {
        return new StringIdentifier(id);
    }

    public FlowPathDefinition start(EventDefinition event) {
        event.with(new StartEvent());
        this.definition.addNode(event);
        return new FlowPathDefinition(this.definition, event);
    }

    public FlowPathDefinition start(AbstractTaskDefinition task) {
        this.definition.addNode(task);
        return new FlowPathDefinition(this.definition, task);
    }

    public FlowPathDefinition after(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id));
    }

    public FlowPathDefinition on(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id, EventDefinition.class));
    }

    public FlowPathDefinition merge(Identifier mergeId, Identifier ... ids) {
        MergeDefinition mergeDefinition = (MergeDefinition)new MergeDefinition().id(mergeId);
        this.definition.addNode(mergeDefinition);
        this.connectToNode(mergeDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, mergeDefinition);
    }

    public FlowPathDefinition join(Identifier joinId, Identifier ... ids) {
        JoinDefinition joinDefinition = (JoinDefinition)new JoinDefinition().id(joinId);
        this.definition.addNode(joinDefinition);
        this.connectToNode(joinDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, joinDefinition);
    }

    private void connectToNode(FlowNodeDefinition node, List<Identifier> idsToConnect) {
        for (Identifier id : idsToConnect) {
            this.definition.getNode(id).addOutgoing(node);
            this.definition.getNode(node.getId()).addIncoming(this.definition.getNode(id));
        }
    }

    public TaskDefinition task(Identifier id) {
        return (TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString());
    }

    public EventDefinition event(Identifier id) {
        return (EventDefinition)((EventDefinition)new EventDefinition().id(id)).display(id.toString());
    }

    public <T> PredicateBuilder<Constant<T>> constant(T value) {
        return new PredicateBuilder<Constant<T>>(new Constant<T>(value));
    }

    public <T> PredicateBuilder<Expression> expression(T expression) {
        return new PredicateBuilder<Expression>(new Expression<T>(expression));
    }

    public MethodCallDefinition service(Class<?> clazz) {
        return new MethodCallDefinition(clazz);
    }

    public PredicateBuilder<MethodCallDefinition> resultOf(MethodCallDefinition methodCall) {
        return new PredicateBuilder<MethodCallDefinition>(methodCall);
    }
}

