/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.builder;

import brainslug.flow.EnumIdentifier;
import brainslug.flow.FlowDefinition;
import brainslug.flow.Identifier;
import brainslug.flow.StringIdentifier;
import brainslug.flow.builder.ServiceCallInvocationSupport;
import brainslug.flow.expression.EqualDefinition;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.Predicate;
import brainslug.flow.expression.PredicateBuilder;
import brainslug.flow.expression.PredicateDefinition;
import brainslug.flow.expression.Property;
import brainslug.flow.expression.TrueDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.event.StartEvent;
import brainslug.flow.node.event.timer.StartTimerDefinition;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.GoalDefinition;
import brainslug.flow.node.task.HandlerCallDefinition;
import brainslug.flow.node.task.InvokeDefinition;
import brainslug.flow.node.task.Task;
import brainslug.flow.path.FlowPathDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FlowBuilderSupport {
    protected FlowDefinition definition;
    protected ServiceCallInvocationSupport serviceCallInvocation = new ServiceCallInvocationSupport();

    public FlowBuilderSupport withDefinition(FlowDefinition definition) {
        this.definition = definition;
        return this;
    }

    public Identifier id(Enum id) {
        return new EnumIdentifier(id);
    }

    public Identifier id(String id) {
        return new StringIdentifier(id);
    }

    public StartTimerDefinition every(int interval, TimeUnit intervalUnit) {
        return new StartTimerDefinition(interval, intervalUnit);
    }

    public FlowPathDefinition start(Identifier startId) {
        return this.start(this.event(startId));
    }

    public FlowPathDefinition start(Identifier startId, StartTimerDefinition startTimerDefinition) {
        return this.start(this.event(startId), startTimerDefinition);
    }

    public FlowPathDefinition start(AbstractEventDefinition event) {
        this.definition.addNode(this.startEvent(event));
        return new FlowPathDefinition(this.definition, event);
    }

    public FlowPathDefinition start(AbstractEventDefinition event, StartTimerDefinition startTimerDefinition) {
        this.definition.addNode(this.startTimerEvent(event, startTimerDefinition));
        return new FlowPathDefinition(this.definition, event);
    }

    protected AbstractEventDefinition startEvent(AbstractEventDefinition event) {
        event.with(new StartEvent());
        return event;
    }

    protected AbstractEventDefinition startTimerEvent(AbstractEventDefinition event, StartTimerDefinition startTimerDefinition) {
        event.with(new StartEvent().withRecurringTimerDefinition(startTimerDefinition));
        return event;
    }

    public FlowPathDefinition start(AbstractTaskDefinition task) {
        this.definition.addNode(task);
        return new FlowPathDefinition(this.definition, task);
    }

    public FlowPathDefinition start(Identifier id, AbstractTaskDefinition task, StartTimerDefinition startTimerDefinition) {
        return this.start(this.event(id), startTimerDefinition).execute(task);
    }

    public FlowPathDefinition after(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id));
    }

    public FlowPathDefinition on(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id, AbstractEventDefinition.class));
    }

    public FlowPathDefinition merge(Identifier mergeId, Identifier ... ids) {
        MergeDefinition mergeDefinition = (MergeDefinition)new MergeDefinition().id(mergeId);
        this.definition.addNode(mergeDefinition);
        this.connectToNode(mergeDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, mergeDefinition);
    }

    public FlowPathDefinition join(Identifier joinId, Identifier ... ids) {
        JoinDefinition joinDefinition = (JoinDefinition)new JoinDefinition().id(joinId);
        this.definition.addNode(joinDefinition);
        this.connectToNode(joinDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, joinDefinition);
    }

    private void connectToNode(FlowNodeDefinition node, List<Identifier> idsToConnect) {
        for (Identifier id : idsToConnect) {
            this.definition.getNode(id).addOutgoing(node);
            this.definition.getNode(node.getId()).addIncoming(this.definition.getNode(id));
        }
    }

    public TaskDefinition task(Identifier id) {
        return (TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString());
    }

    public TaskDefinition task(Identifier id, Task callee) {
        return (TaskDefinition)((TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString())).call(new HandlerCallDefinition(callee));
    }

    public EventDefinition event(Identifier id) {
        return (EventDefinition)((EventDefinition)new EventDefinition().id(id)).display(id.toString());
    }

    public <T> Expression expression(T expression) {
        return new Expression<T>(expression);
    }

    public <T> Expression<T> constant(T constantValue) {
        return this.expression(constantValue);
    }

    public Property property(Identifier id) {
        return new Property(id);
    }

    public <T> T property(Identifier id, Class<T> clazz) {
        return (T)this.val(new Property(id));
    }

    public <T> T val(Expression<T> expression) {
        this.serviceCallInvocation.argument(expression);
        return null;
    }

    public EqualDefinition<Expression, Expression<Object>> eq(Expression actual, Object expected) {
        return new PredicateBuilder<Expression>(actual).isEqualTo(expected);
    }

    public TrueDefinition<Expression> isTrue(Expression actual) {
        return new PredicateBuilder<Expression>(actual).isTrue();
    }

    public <T extends Predicate> PredicateDefinition<T> predicate(T predicate) {
        return new PredicateDefinition<T>(predicate);
    }

    public InvokeDefinition method(Class<?> clazz) {
        return new InvokeDefinition(clazz);
    }

    public CallDefinition method(Object returnValueOfProxyInvocation) {
        return this.serviceCallInvocation.createCallDefinitionFromCurrentStack();
    }

    public <T> T service(Class<T> clazz) {
        return this.serviceCallInvocation.createServiceProxy(clazz);
    }

    public PredicateBuilder<CallDefinition> resultOf(CallDefinition methodCall) {
        return new PredicateBuilder<CallDefinition>(methodCall);
    }

    public GoalDefinition goal(Identifier id) {
        return new GoalDefinition(this.definition).id(id);
    }

    public GoalDefinition check(Identifier id, PredicateDefinition goalPredicate) {
        return new GoalDefinition(this.definition).id(id).check(goalPredicate);
    }

    public GoalDefinition check(Identifier id, Predicate<?> goalPredicate) {
        return new GoalDefinition(this.definition).id(id).check(new PredicateDefinition(goalPredicate));
    }
}

