/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow;

import brainslug.flow.Identifier;
import brainslug.flow.expression.PredicateDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowDefinition {
    private Identifier id;
    private String name;
    List<FlowNodeDefinition> nodes = new ArrayList<FlowNodeDefinition>();
    Map<Identifier, PredicateDefinition> goalPredicates = new HashMap<Identifier, PredicateDefinition>();

    public Option<PredicateDefinition> getGoalPredicate(Identifier goalId) {
        return Option.of(this.goalPredicates.get(goalId));
    }

    public <T extends FlowNodeDefinition> T addNode(T flowNodeDefinition) {
        this.nodes.add(flowNodeDefinition);
        return flowNodeDefinition;
    }

    public FlowNodeDefinition<?> getNode(Identifier id) {
        for (FlowNodeDefinition node : this.nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        throw new IllegalArgumentException("Node with id " + id + " does not exist.");
    }

    public <T extends FlowNodeDefinition> T getNode(Identifier id, Class<T> clazz) {
        FlowNodeDefinition<?> node = this.getNode(id);
        if (!clazz.isAssignableFrom(node.getClass())) {
            throw new IllegalArgumentException("Requested node should have type " + clazz.getName());
        }
        return (T)node;
    }

    public List<FlowNodeDefinition> getNodes() {
        return this.nodes;
    }

    public boolean contains(FlowNodeDefinition<?> flowNodeDefinition) {
        return this.getNodes().contains(flowNodeDefinition);
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FlowDefinition name(String name) {
        this.name = name;
        return this;
    }

    public FlowDefinition id(Identifier id) {
        this.id = id;
        return this;
    }

    public void addGoal(Identifier id, PredicateDefinition predicate) {
        this.goalPredicates.put(id, predicate);
    }
}

