/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.model;

import brainslug.flow.model.AbstractTaskDefinition;
import brainslug.flow.model.AndDefinition;
import brainslug.flow.model.ChoiceDefinition;
import brainslug.flow.model.EventDefinition;
import brainslug.flow.model.FlowDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.ParallelDefinition;
import brainslug.flow.model.marker.EndEvent;
import brainslug.flow.model.marker.IntermediateEvent;
import java.util.LinkedList;

public class FlowPathDefinition<Self extends FlowPathDefinition> {
    final FlowDefinition definition;
    LinkedList<FlowNodeDefinition> pathNodes = new LinkedList();

    public FlowPathDefinition(FlowDefinition definition, FlowNodeDefinition startNode) {
        this.definition = definition;
        this.pathNodes.add(startNode);
        startNode.setFlowPathDefinition(this);
    }

    public ChoiceDefinition choice(Identifier id) {
        return (ChoiceDefinition)((ChoiceDefinition)this.appendNode(new ChoiceDefinition(this)).id(id)).self();
    }

    public AndDefinition parallel(Identifier id) {
        return ((ParallelDefinition)((ParallelDefinition)this.appendNode(new ParallelDefinition(this).id(id))).self()).fork();
    }

    public Self execute(AbstractTaskDefinition taskDefinition) {
        this.appendNode(taskDefinition);
        return this.then();
    }

    public Self waitFor(EventDefinition eventDefinition) {
        eventDefinition.with(new IntermediateEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    public Self end(FlowNodeDefinition<EventDefinition> eventDefinition) {
        if (this.definition.contains(eventDefinition)) {
            this.addToPath(eventDefinition);
            this.connect(this.pathNodes.getLast(), this.definition.getNode(eventDefinition.getId()));
            return this.then();
        }
        eventDefinition.with(new EndEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    protected <T extends FlowNodeDefinition> T appendNode(T flowNodeDefinition) {
        if (this.definition.contains(flowNodeDefinition)) {
            throw new IllegalStateException("Node already exists");
        }
        this.connect(this.pathNodes.getLast(), flowNodeDefinition);
        this.addToPath(flowNodeDefinition);
        this.definition.addNode(flowNodeDefinition);
        return flowNodeDefinition;
    }

    protected <T extends FlowNodeDefinition> void addToPath(T flowNodeDefinition) {
        this.pathNodes.add(flowNodeDefinition);
        flowNodeDefinition.setFlowPathDefinition(this);
    }

    protected <T extends FlowNodeDefinition> void connect(FlowNodeDefinition previousNode, T flowNodeDefinition) {
        previousNode.addOutgoing(flowNodeDefinition);
        flowNodeDefinition.addIncoming(previousNode);
    }

    public Self then() {
        return (Self)this;
    }

    public LinkedList<FlowNodeDefinition> getPathNodes() {
        return this.pathNodes;
    }

    public FlowNodeDefinition getStartNode() {
        return this.pathNodes.getFirst();
    }
}

