/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.impl;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.ExecutionProperties;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.FlowNodeExectuor;
import brainslug.flow.execution.Token;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.execution.TokenStoreAware;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.impl.ChoiceNodeExecutor;
import brainslug.flow.execution.impl.DefaultExecutionContext;
import brainslug.flow.execution.impl.DefaultNodeExecutor;
import brainslug.flow.execution.impl.JoinNodeExecutor;
import brainslug.flow.execution.impl.TaskNodeExecutor;
import brainslug.flow.listener.EventType;
import brainslug.flow.model.ChoiceDefinition;
import brainslug.flow.model.EventDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.JoinDefinition;
import brainslug.flow.model.MergeDefinition;
import brainslug.flow.model.ParallelDefinition;
import brainslug.flow.model.TaskDefinition;
import brainslug.flow.model.marker.IntermediateEvent;
import brainslug.flow.model.marker.StartEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFlowExecutor
implements FlowExecutor {
    private Logger log = LoggerFactory.getLogger(TokenFlowExecutor.class);
    protected BrainslugContext context;
    protected TokenStore tokenStore;
    Map<Class<? extends FlowNodeDefinition>, FlowNodeExectuor> nodeExecutors = new HashMap<Class<? extends FlowNodeDefinition>, FlowNodeExectuor>();

    public TokenFlowExecutor(BrainslugContext context) {
        this.context = context;
        this.tokenStore = context.getTokenStore();
        this.addNodeExecutorMappings();
    }

    protected void addNodeExecutorMappings() {
        this.nodeExecutors.put(EventDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(ParallelDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(MergeDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(ChoiceDefinition.class, new ChoiceNodeExecutor());
        this.nodeExecutors.put(JoinDefinition.class, new JoinNodeExecutor(this.tokenStore));
        this.nodeExecutors.put(TaskDefinition.class, new TaskNodeExecutor());
    }

    FlowNodeDefinition<?> getNode(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition node = this.context.getDefinitionStore().findById(definitionId).getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException(String.format("node for does not exist %s", nodeId));
        }
        return node;
    }

    protected <T extends FlowNodeDefinition> FlowNodeExectuor<T> getNodeExecutor(T nodeDefinition) {
        FlowNodeExectuor nodeExecutor = this.nodeExecutors.get(nodeDefinition.getClass());
        if (nodeExecutor == null) {
            throw new IllegalArgumentException(String.format("no executor found for node definition %s", nodeDefinition));
        }
        if (nodeExecutor instanceof TokenStoreAware) {
            ((TokenStoreAware)((Object)nodeExecutor)).setTokenStore(this.tokenStore);
        }
        return nodeExecutor;
    }

    @Override
    public void setContext(BrainslugContext context) {
        this.context = context;
    }

    @Override
    public Identifier startFlow(TriggerContext<?> trigger) {
        FlowNodeDefinition<?> node = this.getStartNodeDefinition(trigger.getDefinitionId(), trigger.getNodeId());
        Identifier instanceId = this.context.getIdGenerator().generateId();
        this.tokenStore.createInstance(instanceId);
        this.tokenStore.addToken(instanceId, trigger.getNodeId(), new Token(trigger.getNodeId()));
        this.context.getPropertyStore().storeProperties(trigger.getInstanceId(), trigger.getProperties());
        this.context.trigger((TriggerContext)((TriggerContext)((TriggerContext)((TriggerContext)((TriggerContext)new TriggerContext().sourceNodeId(node.getId())).nodeId(node.getId())).definitionId(trigger.getDefinitionId())).instanceId(instanceId)).properties(trigger.getProperties()));
        return instanceId;
    }

    protected FlowNodeDefinition<?> getStartNodeDefinition(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition<?> node = this.getNode(definitionId, nodeId);
        if (!node.hasMixin(StartEvent.class)) {
            throw new IllegalArgumentException("flow must be started with start event");
        }
        return node;
    }

    @Override
    public void trigger(TriggerContext<?> triggerContext) {
        this.log.debug("triggering {}", triggerContext);
        FlowNodeDefinition<?> node = this.getNode(triggerContext.getDefinitionId(), triggerContext.getNodeId());
        FlowNodeExectuor<FlowNodeDefinition<?>> nodeExecutor = this.getNodeExecutor(node);
        ExecutionContext executionContext = this.createExecutionContext(triggerContext);
        this.context.getListenerManager().notifyListeners(EventType.BEFORE_EXECUTION, triggerContext);
        List<FlowNodeDefinition> next = nodeExecutor.execute(node, executionContext);
        this.context.getPropertyStore().storeProperties(triggerContext.getInstanceId(), triggerContext.getProperties());
        this.context.getListenerManager().notifyListeners(EventType.AFTER_EXECUTION, triggerContext);
        this.triggerNext(triggerContext, node, next);
    }

    protected ExecutionContext createExecutionContext(TriggerContext triggerContext) {
        DefaultExecutionContext executionContext = new DefaultExecutionContext(triggerContext, this.context);
        if (triggerContext.getInstanceId() != null) {
            executionContext.getTrigger().properties(this.mergeProperties(triggerContext, executionContext));
        }
        return executionContext;
    }

    protected ExecutionProperties mergeProperties(TriggerContext triggerContext, DefaultExecutionContext executionContext) {
        ExecutionProperties properties = this.context.getPropertyStore().loadProperties(executionContext.getTrigger().getInstanceId());
        properties.putAll(triggerContext.getProperties());
        return properties;
    }

    protected void triggerNext(TriggerContext event, FlowNodeDefinition<?> node, List<FlowNodeDefinition> next) {
        for (FlowNodeDefinition nextNode : next) {
            this.addToken(event, node, nextNode);
            if (this.waitingForExternalTrigger(nextNode)) continue;
            this.context.trigger(this.createTriggerContextForNextNode(event, node, nextNode));
        }
    }

    protected boolean waitingForExternalTrigger(FlowNodeDefinition nextNode) {
        return nextNode.hasMixin(IntermediateEvent.class);
    }

    protected TriggerContext createTriggerContextForNextNode(TriggerContext<?> event, FlowNodeDefinition<?> currentNode, FlowNodeDefinition nextNode) {
        return ((TriggerContext)((TriggerContext)((TriggerContext)((TriggerContext)new TriggerContext().nodeId(nextNode.getId())).sourceNodeId(currentNode.getId())).definitionId(event.getDefinitionId())).instanceId(event.getInstanceId())).properties(event.getProperties());
    }

    protected void addToken(TriggerContext event, FlowNodeDefinition<?> node, FlowNodeDefinition nextNode) {
        if (event.getInstanceId() != null) {
            this.tokenStore.addToken(event.getInstanceId(), nextNode.getId(), new Token(node.getId()));
        }
    }
}

