/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.HashMapRegistry;
import brainslug.flow.context.IdGenerator;
import brainslug.flow.context.PredicateEvaluator;
import brainslug.flow.context.Registry;
import brainslug.flow.execution.ExecutionProperties;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.PropertyStore;
import brainslug.flow.execution.Scheduler;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.expression.DefaultPredicateEvaluator;
import brainslug.flow.execution.impl.ExecutorServiceScheduler;
import brainslug.flow.execution.impl.HashMapPropertyStore;
import brainslug.flow.execution.impl.HashMapTokenStore;
import brainslug.flow.execution.impl.TokenFlowExecutor;
import brainslug.flow.listener.DefaultListenerManager;
import brainslug.flow.listener.ListenerManager;
import brainslug.flow.model.DefinitionStore;
import brainslug.flow.model.FlowDefinition;
import brainslug.flow.model.Identifier;
import brainslug.util.UuidGenerator;

public class BrainslugContext {
    Scheduler scheduler;
    DefinitionStore definitionStore;
    ListenerManager listenerManager;
    FlowExecutor flowExecutor;
    TokenStore tokenStore;
    PropertyStore propertyStore;
    PredicateEvaluator predicateEvaluator;
    IdGenerator idGenerator;
    Registry registry;

    public BrainslugContext() {
        this.withScheduler(new ExecutorServiceScheduler());
        this.withDefinitionStore(new DefinitionStore());
        this.withListenerManager(new DefaultListenerManager());
        this.withTokenStore(new HashMapTokenStore());
        this.withExecutor(new TokenFlowExecutor(this));
        this.withRegistry(new HashMapRegistry());
        this.withPredicateEvaluator(new DefaultPredicateEvaluator());
        this.withIdGenerator(new UuidGenerator());
        this.withPropertyStore(new HashMapPropertyStore());
    }

    public BrainslugContext withScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        scheduler.setContext(this);
        return this;
    }

    public BrainslugContext withPropertyStore(HashMapPropertyStore propertyStore) {
        this.propertyStore = propertyStore;
        return this;
    }

    public BrainslugContext withDefinitionStore(DefinitionStore definitionStore) {
        this.definitionStore = definitionStore;
        return this;
    }

    public BrainslugContext withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public BrainslugContext withExecutor(FlowExecutor newFlowExecutor) {
        this.setupFlowExecutor(newFlowExecutor);
        return this;
    }

    private void setupFlowExecutor(FlowExecutor newFlowExecutor) {
        this.flowExecutor = newFlowExecutor;
        this.flowExecutor.setContext(this);
    }

    public BrainslugContext withListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        return this;
    }

    public BrainslugContext withRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public BrainslugContext withPredicateEvaluator(PredicateEvaluator predicateEvaluator) {
        this.predicateEvaluator = predicateEvaluator;
        return this;
    }

    public BrainslugContext withIdGenerator(UuidGenerator uuidGenerator) {
        this.idGenerator = uuidGenerator;
        return this;
    }

    public BrainslugContext addFlowDefinition(FlowDefinition flowDefinition) {
        this.definitionStore.addDefinition(flowDefinition);
        return this;
    }

    public DefinitionStore getDefinitionStore() {
        return this.definitionStore;
    }

    public void trigger(TriggerContext context) {
        this.flowExecutor.trigger(context);
    }

    public Identifier startFlow(Identifier definitionId, Identifier startNodeId, ExecutionProperties properties) {
        Object triggerContext = ((TriggerContext)((TriggerContext)new TriggerContext().definitionId(definitionId)).nodeId(startNodeId)).properties(properties);
        return this.flowExecutor.startFlow((TriggerContext<?>)triggerContext);
    }

    public Identifier startFlow(Identifier definitionId, Identifier startNodeId) {
        return this.flowExecutor.startFlow((TriggerContext<?>)((TriggerContext)new TriggerContext().definitionId(definitionId)).nodeId(startNodeId));
    }

    public Identifier startFlow(TriggerContext context) {
        return this.flowExecutor.startFlow(context);
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public PredicateEvaluator getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propertyStore;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }
}

