/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client;

import de.ameto.client.AmetoApi;
import de.ameto.client.AmetoException;
import de.ameto.client.Asset;
import de.ameto.client.AssetReference;
import de.ameto.client.DefaultOperator;
import de.ameto.client.Job;
import de.ameto.client.PipelineDto;
import de.ameto.client.ProcessedAsset;
import de.ameto.client.SubmitJobRequest;
import de.ameto.client.SubmitJobResponse;
import de.ameto.client.operators.Operator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class Pipeline {
    private final AmetoApi api;
    private final String id;
    private final String name;
    private final List<Operator> steps;

    public ProcessedAsset push(Asset asset) {
        String jobId = this.submitJob(new AssetReference(asset.getId()), this.getId());
        int retries = 6;
        double retryBackoff = 1000.0;
        double retryBackoffExponent = 1.1;
        for (int attempt = 0; attempt < retries; ++attempt) {
            Response jobsResponse;
            try {
                jobsResponse = this.api.getJob(jobId).execute();
            }
            catch (IOException e) {
                throw new AmetoException("Unable to request job data.", e);
            }
            if (!jobsResponse.isSuccessful() && jobsResponse.code() != 404) {
                Optional<ResponseBody> errorBody = Optional.ofNullable(jobsResponse.errorBody());
                String errorMessage = "An error occurred when fetching job information for job " + jobId;
                if (errorBody.isPresent()) {
                    try {
                        errorMessage = errorBody.get().string();
                    }
                    catch (IOException e) {
                        throw new AmetoException("Unable to deserialize error message.", e);
                    }
                }
                throw new AmetoException(errorMessage);
            }
            Optional<ProcessedAsset> jobResult = Optional.ofNullable(jobsResponse.body()).filter(j -> j.getStatus() == Job.Status.Finished).map(j -> new ProcessedAsset(j.getResult().get().getId(), this.api));
            if (jobResult.isPresent()) {
                return jobResult.get();
            }
            try {
                Thread.sleep((long)retryBackoff);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            retryBackoff = Math.pow(retryBackoff, retryBackoffExponent);
        }
        throw new AmetoException("Job result could not be retrieved.");
    }

    private String submitJob(AssetReference asset, String pipeline) {
        SubmitJobRequest job = new SubmitJobRequest(asset, pipeline);
        Response addJobResponse = null;
        try {
            addJobResponse = this.api.add(job).execute();
        }
        catch (IOException e) {
            throw new AmetoException("Unable to submit job.");
        }
        if (!addJobResponse.isSuccessful()) {
            Optional<ResponseBody> errorResponse = Optional.ofNullable(addJobResponse.errorBody());
            String errorMessage = errorResponse.map(responseBody -> {
                try {
                    return responseBody.string();
                }
                catch (IOException e) {
                    throw new AmetoException("Unable to deserialize error message", e);
                }
            }).orElse("Unspecified error");
            throw new AmetoException("Job submission failed with the following error:" + errorMessage);
        }
        Optional<Object> jobResponse = Optional.ofNullable(addJobResponse.body());
        return ((SubmitJobResponse)jobResponse.orElseThrow(() -> new AmetoException("Job submission returned empty response"))).getId();
    }

    @ConstructorProperties(value={"api", "id", "name", "steps"})
    Pipeline(AmetoApi api, String id, String name, List<Operator> steps) {
        this.api = api;
        this.id = id;
        this.name = name;
        this.steps = steps;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Operator> getSteps() {
        return this.steps;
    }

    public static class FinalizableBuilder {
        private final AmetoApi api;
        private final String name;
        private final List<Operator> steps;

        public Pipeline build() {
            Response response;
            try {
                List<PipelineDto.Step> steps_ = this.steps.stream().map(op -> new PipelineDto.Step(op.getName(), op.getVersion(), op.getArguments())).collect(Collectors.toList());
                PipelineDto pipeline = new PipelineDto(this.name, steps_);
                response = this.api.add(pipeline).execute();
                if (!response.isSuccessful()) {
                    Optional<ResponseBody> errorResponse = Optional.ofNullable(response.errorBody());
                    if (errorResponse.isPresent()) {
                        throw new AmetoException(errorResponse.get().string());
                    }
                    throw new AmetoException("An error occurred when submitting the pipeline to the server.");
                }
            }
            catch (IOException e) {
                throw new AmetoException("Unable to send pipeline request to the Ameto API server", e);
            }
            String pipelineId = ((PipelineDto)response.body()).getId();
            return new Pipeline(this.api, pipelineId, this.name, this.steps);
        }

        @ConstructorProperties(value={"api", "name", "steps"})
        FinalizableBuilder(AmetoApi api, String name, List<Operator> steps) {
            this.api = api;
            this.name = name;
            this.steps = steps;
        }
    }

    public static class Builder {
        private final AmetoApi api;
        private final String name;
        private final LinkedList<Operator> steps;

        Builder(AmetoApi api, String name) {
            this.api = api;
            this.name = name;
            this.steps = new LinkedList();
            this.steps.add(new DefaultOperator("normalize", "1.0.0", Collections.singletonList("image/jpeg"), Collections.emptyList()));
        }

        public Builder autoOrient() {
            this.steps.addFirst(new DefaultOperator("read_exif", "1.0.0", Collections.singletonList("image/jpeg"), Collections.emptyList()));
            this.steps.add(new DefaultOperator("auto_orient", "1.0.0", Collections.singletonList("image/png"), Collections.emptyList()));
            return this;
        }

        public Builder resize(int width, int height) {
            return this.resize(width, height, ResizeMode.FIT);
        }

        public Builder resize(int width, int height, ResizeMode mode) {
            String modeAsString;
            switch (mode) {
                case EXACT: {
                    modeAsString = "exact";
                    break;
                }
                case FILL: {
                    modeAsString = "fill";
                    break;
                }
                case FIT: {
                    modeAsString = "fit";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported value for mode: " + (Object)((Object)mode));
                }
            }
            List<String> arguments = Arrays.asList(String.valueOf(width), String.valueOf(height), "--mode", modeAsString);
            this.steps.add(new DefaultOperator("resize", "1.0.0", Collections.singletonList("image/jpeg"), arguments));
            return this;
        }

        public FinalizableBuilder format(Format format) {
            if (format != Format.Jpeg) {
                throw new IllegalArgumentException("Unknown output format: " + (Object)((Object)format));
            }
            DefaultOperator outputOperator = new DefaultOperator("shrink", "1.1.0", Arrays.asList("image/jpeg", "image/png"), Collections.emptyList());
            this.steps.add(outputOperator);
            return new FinalizableBuilder(this.api, this.name, this.steps);
        }
    }

    public static enum ResizeMode {
        EXACT,
        FILL,
        FIT;

    }

    public static enum Format {
        Jpeg;

    }
}

