/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client.operators;

import de.ameto.client.operators.Operator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Resize
implements Operator {
    private final String version;
    private final List<String> arguments;

    public Resize(int width, int height) {
        this(width, height, Mode.FIT);
    }

    public Resize(int width, int height, Mode mode) {
        String modeAsString;
        this.version = "1.0.0";
        switch (mode) {
            case EXACT: {
                modeAsString = "exact";
                break;
            }
            case FILL: {
                modeAsString = "fill";
                break;
            }
            case FIT: {
                modeAsString = "fit";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for mode: " + (Object)((Object)mode));
            }
        }
        this.arguments = Arrays.asList(String.valueOf(width), String.valueOf(height), "--mode", modeAsString);
    }

    @Deprecated
    public Resize(String version, int width, int height) {
        this(version, width, height, Mode.FIT);
    }

    @Deprecated
    public Resize(String version, int width, int height, Mode mode) {
        String modeAsString;
        this.version = version;
        switch (mode) {
            case EXACT: {
                modeAsString = "exact";
                break;
            }
            case FILL: {
                modeAsString = "fill";
                break;
            }
            case FIT: {
                modeAsString = "fit";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for mode: " + (Object)((Object)mode));
            }
        }
        this.arguments = Arrays.asList(String.valueOf(width), String.valueOf(height), "--mode", modeAsString);
    }

    @Override
    public String getName() {
        return "resize";
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public List<String> getConsumes() {
        return Collections.singletonList("image/jpeg");
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public static enum Mode {
        EXACT,
        FILL,
        FIT;

    }
}

