/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xsl.transform;

import java.io.File;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.NonNull;

public final class XsltTransformerExtensions {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    public static Transformer getTransformer(File xsltFile) throws TransformerConfigurationException {
        return XsltTransformerExtensions.getTransformer(new StreamSource(xsltFile));
    }

    public static Transformer getTransformer(Source xsltSource) throws TransformerConfigurationException {
        return TRANSFORMER_FACTORY.newTransformer(xsltSource);
    }

    public static Transformer getTransformer(String xsltInputFile) throws TransformerConfigurationException {
        return XsltTransformerExtensions.getTransformer(new File(xsltInputFile));
    }

    public static void transform(@NonNull File xmlFile, @NonNull File xsltFile, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        if (xmlFile == null) {
            throw new NullPointerException("xmlFile is marked @NonNull but is null");
        }
        if (xsltFile == null) {
            throw new NullPointerException("xsltFile is marked @NonNull but is null");
        }
        StreamSource xmlSource = new StreamSource(xmlFile);
        StreamSource xsltSource = new StreamSource(xsltFile);
        XsltTransformerExtensions.transform(xmlSource, xsltSource, outputStream);
    }

    public static void transform(Source xmlSource, Source xsltSource, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = XsltTransformerExtensions.getTransformer(xsltSource);
        transformer.transform(xmlSource, new StreamResult(outputStream));
    }

    public static void transform(String xmlInputFile, String xsltInputFile, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        File xmlFile = new File(xmlInputFile);
        File xsltFile = new File(xsltInputFile);
        XsltTransformerExtensions.transform(xmlFile, xsltFile, outputStream);
    }

    private XsltTransformerExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

