/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.tag;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.xml.tag.TagExtensions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimpleTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> attributes;
    private List<SimpleTag> children;
    private String content;
    private boolean endTag;
    private String name;

    public String addAttribute(String name, String value) {
        if (this.getAttributes() == null) {
            this.setAttributes(MapFactory.newLinkedHashMap());
        }
        return this.getAttributes().put(name, value);
    }

    public boolean addChild(SimpleTag child) {
        if (this.getChildren() == null) {
            this.setChildren(ListFactory.newArrayList((Object[])new SimpleTag[0]));
        }
        return this.getChildren().add(child);
    }

    public Object clone() {
        return CloneObjectQuietlyExtensions.cloneQuietly((Object)this);
    }

    public String removeAttribute(String name) {
        if (this.getAttributes() != null) {
            this.getAttributes().remove(name);
        }
        return null;
    }

    public boolean removeChild(SimpleTag child) {
        if (this.getChildren() != null) {
            return this.getChildren().remove(child);
        }
        return false;
    }

    public StringBuilder toVelocityTemplate() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append("${").append(this.getName()).append(".name}\n");
        if (this.getAttributes() != null && !this.getAttributes().isEmpty()) {
            buffer.append(" #foreach($attribute in $").append(this.getName()).append(".attributes.keySet())\n");
            buffer.append("$attribute=\"$").append(this.getName()).append(".getAttributes().get($attribute)\"\n");
            buffer.append(" #end\n");
        }
        buffer.append("#if(${").append(this.getName()).append(".endTag})>${").append(this.getName()).append(".content}\n");
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            buffer.append("#foreach($").append(this.getChildren().get(0).getName()).append(" in $").append(this.getName()).append(".children)\n");
            for (SimpleTag child : this.getChildren()) {
                buffer.append(child.toVelocityTemplate().toString());
            }
            buffer.append("#end\n");
        }
        buffer.append("</${").append(this.getName()).append(".name}>\n");
        buffer.append("#else />\n#end\n");
        return buffer;
    }

    public String toXmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append(this.getName());
        Optional<String> attr = TagExtensions.attributesToString(this.getAttributes());
        if (attr.isPresent()) {
            buffer.append(attr.get());
        }
        if (this.isEndTag()) {
            buffer.append(">");
            buffer.append(this.getContent());
            if (this.getChildren() != null && !this.getChildren().isEmpty()) {
                for (SimpleTag child : this.getChildren()) {
                    buffer.append(child.toXmlString());
                }
            }
            buffer.append("</");
            buffer.append(this.getName());
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        return buffer.toString();
    }

    public static SimpleTagBuilder builder() {
        return new SimpleTagBuilder();
    }

    public SimpleTagBuilder toBuilder() {
        return new SimpleTagBuilder().attributes(this.attributes).children(this.children).content(this.content).endTag(this.endTag).name(this.name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<SimpleTag> getChildren() {
        return this.children;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setChildren(List<SimpleTag> children) {
        this.children = children;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setEndTag(boolean endTag) {
        this.endTag = endTag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "SimpleTag(content=" + this.getContent() + ", endTag=" + this.isEndTag() + ", name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleTag)) {
            return false;
        }
        SimpleTag other = (SimpleTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        if (this.isEndTag() != other.isEndTag()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + (this.isEndTag() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public SimpleTag() {
    }

    public SimpleTag(Map<String, String> attributes, List<SimpleTag> children, String content, boolean endTag, String name) {
        this.attributes = attributes;
        this.children = children;
        this.content = content;
        this.endTag = endTag;
        this.name = name;
    }

    public static class SimpleTagBuilder {
        private Map<String, String> attributes;
        private List<SimpleTag> children;
        private String content;
        private boolean endTag;
        private String name;

        SimpleTagBuilder() {
        }

        public SimpleTagBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SimpleTagBuilder children(List<SimpleTag> children) {
            this.children = children;
            return this;
        }

        public SimpleTagBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SimpleTagBuilder endTag(boolean endTag) {
            this.endTag = endTag;
            return this;
        }

        public SimpleTagBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SimpleTag build() {
            return new SimpleTag(this.attributes, this.children, this.content, this.endTag, this.name);
        }

        public String toString() {
            return "SimpleTag.SimpleTagBuilder(attributes=" + this.attributes + ", children=" + this.children + ", content=" + this.content + ", endTag=" + this.endTag + ", name=" + this.name + ")";
        }
    }
}

