/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.core;

import de.alpharogroup.wicket.js.addon.core.QuotationMarkType;
import de.alpharogroup.wicket.js.addon.core.StringTextValue;
import java.util.Map;
import java.util.Set;

public class TextTemplateExtensions {
    public static String asJavascriptArray(Set<StringTextValue<?>> settings) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        int count = 1;
        for (StringTextValue<?> textValue : settings) {
            switch (textValue.getType()) {
                case STRING: {
                    if (textValue.getQuotationMarkType().equals((Object)QuotationMarkType.NONE)) {
                        sb.append(textValue.getName());
                        sb.append(":");
                        sb.append(textValue.getValue());
                        break;
                    }
                    sb.append(textValue.getName());
                    sb.append(":");
                    sb.append("\"" + textValue.getValue() + "\"");
                    break;
                }
                default: {
                    sb.append(textValue.getName());
                    sb.append(":");
                    sb.append(textValue.getValue());
                }
            }
            if (count < settings.size()) {
                sb.append(",\n");
            }
            ++count;
        }
        sb.append("\n}");
        return sb.toString();
    }

    public static void setVariableWithSingleQuotationMarks(String variablename, Object object, Map<String, Object> variables) {
        if (object != null) {
            variables.put(variablename, "'" + object + "'");
        } else {
            variables.put(variablename, "null");
        }
    }
}

