/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTextTemplate
extends TextTemplate {
    private static final long serialVersionUID = 1L;
    static final Logger LOGGER = LoggerFactory.getLogger((String)StringTextTemplate.class.getName());
    private final StringBuilder buffer = new StringBuilder();

    public StringTextTemplate(String content) {
        this(content, "text", "UTF-8");
    }

    public StringTextTemplate(String content, String contentType, String encoding) {
        super(contentType);
        StringResourceStream stream = new StringResourceStream((CharSequence)content, this.getContentType());
        try {
            if (encoding != null) {
                this.buffer.append(Streams.readString((InputStream)stream.getInputStream(), (CharSequence)encoding));
            } else {
                this.buffer.append(Streams.readString((InputStream)stream.getInputStream()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error("" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getString() {
        return this.buffer.toString();
    }

    public TextTemplate interpolate(Map<String, ?> variables) {
        if (variables != null) {
            String result = new MapVariableInterpolator(this.buffer.toString(), variables).toString();
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(result);
        }
        return this;
    }
}

