/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.core;

import de.alpharogroup.wicket.js.addon.core.QuotationMarkType;
import de.alpharogroup.wicket.js.addon.core.Settings;
import de.alpharogroup.wicket.js.addon.core.StringTextTemplate;
import de.alpharogroup.wicket.js.addon.core.StringTextValue;
import de.alpharogroup.wicket.js.addon.core.TextTemplateExtensions;
import de.alpharogroup.wicket.js.addon.core.ValueEnum;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptGenerator<S extends Settings>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COMPONENT_ID = "componentId";
    public static final String DOCUMENT_READY_FUNCTION_PREFIX = "$(document).ready(function() {";
    public static final String DOCUMENT_READY_FUNCTION_SUFFIX = "})";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)JavascriptGenerator.class.getName());
    private String componentId;
    private boolean withComponentId;
    private String methodName;
    private S settings;
    private boolean withDocumentReadyFunction;

    public JavascriptGenerator(S settings) {
        this.settings = (Settings)Args.notNull(settings, (String)"settings");
    }

    protected String generateJavascriptTemplateContent(Map<String, Object> variables, String methodName) {
        StringBuilder sb = new StringBuilder();
        if (this.isWithDocumentReadyFunction()) {
            sb.append(DOCUMENT_READY_FUNCTION_PREFIX).append("\n");
        }
        if (this.isWithComponentId()) {
            sb.append("$('#${").append(COMPONENT_ID).append("}')").append(".");
        } else {
            sb.append("$.");
        }
        sb.append(methodName).append("(");
        if (this.isWithComponentId()) {
            if (1 < variables.size()) {
                this.generateJsOptionsForTemplateContent(variables, sb);
            }
        } else if (0 < variables.size()) {
            this.generateJsOptionsForTemplateContent(variables, sb);
        }
        sb.append(");").append("\n");
        if (this.isWithDocumentReadyFunction()) {
            sb.append(DOCUMENT_READY_FUNCTION_SUFFIX);
        }
        return sb.toString();
    }

    public String generateJs() {
        return this.generateJs((Settings)this.getSettings(), this.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateJs(Settings settings, String methodName) {
        Map<String, Object> variables = this.initializeVariables(settings.asSet());
        String stringTemplateContent = this.generateJavascriptTemplateContent(variables, methodName);
        StringTextTemplate stringTextTemplate = new StringTextTemplate(stringTemplateContent);
        stringTextTemplate.interpolate(variables);
        try {
            String string = stringTextTemplate.asString();
            return string;
        }
        finally {
            try {
                stringTextTemplate.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void generateJsOptionsForTemplateContent(Map<String, Object> variables, StringBuilder sb) {
        sb.append("{\n");
        int count = 1;
        Object localComponentId = null;
        if (this.withComponentId) {
            localComponentId = variables.get(COMPONENT_ID);
            variables.remove(COMPONENT_ID);
        }
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String key = entry.getKey();
            sb.append(key).append(": ${").append(key).append("}");
            if (count < variables.size()) {
                sb.append(",\n");
            } else {
                sb.append("\n");
            }
            ++count;
        }
        if (this.withComponentId) {
            variables.put(COMPONENT_ID, localComponentId);
        }
        sb.append("}");
    }

    protected Map<String, Object> initializeVariables(Set<StringTextValue<?>> allSettings) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.withComponentId) {
            variables.put(COMPONENT_ID, this.componentId);
        }
        block5: for (StringTextValue<?> textValue : allSettings) {
            if (textValue.isInitialValue()) continue;
            switch (textValue.getType()) {
                case STRING: {
                    if (textValue.getQuotationMarkType().equals((Object)QuotationMarkType.NONE)) {
                        variables.put(textValue.getName(), textValue.getValue());
                        continue block5;
                    }
                    TextTemplateExtensions.setVariableWithSingleQuotationMarks(textValue.getName(), textValue.getValue(), variables);
                    continue block5;
                }
                case ENUM: {
                    TextTemplateExtensions.setVariableWithSingleQuotationMarks(textValue.getName(), ((ValueEnum)textValue.getValue()).getValue(), variables);
                    continue block5;
                }
                case STRING_INTEGER: {
                    TextTemplateExtensions.setVariableWithSingleQuotationMarks(textValue.getName(), textValue.getValue(), variables);
                    continue block5;
                }
            }
            variables.put(textValue.getName(), textValue.getValue());
        }
        return variables;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public boolean isWithComponentId() {
        return this.withComponentId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public S getSettings() {
        return this.settings;
    }

    public boolean isWithDocumentReadyFunction() {
        return this.withDocumentReadyFunction;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setWithComponentId(boolean withComponentId) {
        this.withComponentId = withComponentId;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setSettings(S settings) {
        this.settings = settings;
    }

    public void setWithDocumentReadyFunction(boolean withDocumentReadyFunction) {
        this.withDocumentReadyFunction = withDocumentReadyFunction;
    }
}

