/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.list.ListExtensions;
import java.util.List;
import java.util.Optional;

public final class OptionalListExtensions {
    public static <T> Optional<T> getFirst(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getLast(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(list.size() - 1));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getNext(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        if (ListExtensions.hasNext(list, element)) {
            int nextIndex = list.indexOf(element) + 1;
            return Optional.of(list.get(nextIndex));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getPrevious(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        if (indexOfElement == -1 || indexOfElement == 0) {
            return Optional.empty();
        }
        int previousIndex = indexOfElement - 1;
        return Optional.of(list.get(previousIndex));
    }

    public static <T> Optional<T> removeFirst(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (!CollectionExtensions.isEmpty(list)) {
            return Optional.of(list.remove(0));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> removeLast(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (!CollectionExtensions.isEmpty(list)) {
            return Optional.of(list.remove(list.size() - 1));
        }
        return Optional.empty();
    }

    private OptionalListExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

