/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.properties;

import de.alpharogroup.collections.list.ListFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesExtensions {
    public static final String SEARCH_FILE_PATTERN = "([^\\s]+(\\.(?i)(java|html|htm))$)";
    public static final String[] PROPERTIES_DELIMITERS = new String[]{"=", ":", " "};

    public static Map<String, List<String>> findRedundantValues(Properties properties) {
        List keys;
        LinkedHashMap<String, List> reverseEntries = new LinkedHashMap<String, List>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!reverseEntries.containsKey(value)) {
                keys = ListFactory.newArrayList(new String[0]);
                keys.add(key);
                reverseEntries.put(value, keys);
                continue;
            }
            keys = (List)reverseEntries.get(value);
            keys.add(key);
        }
        LinkedHashMap<String, List<String>> redundantValues = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : reverseEntries.entrySet()) {
            String key = (String)entry.getKey();
            keys = (List)entry.getValue();
            if (1 >= keys.size()) continue;
            redundantValues.put(key, keys);
        }
        return redundantValues;
    }

    public static Map<String, List<String>> getMatchedPrefixLists(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        LinkedHashMap<String, List<String>> matchedPrefixes = new LinkedHashMap<String, List<String>>();
        while (e.hasMoreElements()) {
            List fullKeys;
            String key = (String)e.nextElement();
            int lastIndex = key.lastIndexOf(".");
            String subKey = null;
            subKey = 0 < lastIndex ? key.substring(0, lastIndex) : key;
            if (matchedPrefixes.containsKey(subKey)) {
                fullKeys = (List)matchedPrefixes.get(subKey);
                fullKeys.add(key);
                continue;
            }
            fullKeys = ListFactory.newArrayList(new String[0]);
            fullKeys.add(key);
            matchedPrefixes.put(subKey, fullKeys);
        }
        return matchedPrefixes;
    }

    public static List<String> getPropertyParameters(String propertyValue) {
        List<String> parameterList = ListFactory.newArrayList(new String[0]);
        Pattern pattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = pattern.matcher(propertyValue);
        while (matcher.find()) {
            String parameter = matcher.group();
            String at = parameter.substring(1, parameter.length() - 1);
            parameterList.add(at);
        }
        return parameterList;
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        return PropertiesExtensions.loadProperties(propertiesFile, false);
    }

    public static Properties loadProperties(File propertiesFile, boolean loadFromXML) throws IOException {
        Properties properties = null;
        InputStream inputStream = null;
        if (propertiesFile.exists()) {
            inputStream = propertiesFile.toURI().toURL().openStream();
            if (inputStream != null) {
                properties = new Properties();
                if (loadFromXML) {
                    properties.loadFromXML(inputStream);
                } else {
                    properties.load(inputStream);
                }
            }
        } else {
            throw new FileNotFoundException(propertiesFile.getName() + " not found.");
        }
        return properties;
    }

    public static void toProperties(File properties, File xml, String comment) throws IOException {
        PropertiesExtensions.toProperties(new FileOutputStream(properties), new FileInputStream(xml), comment);
    }

    public static void toProperties(OutputStream properties, InputStream xml, String comment) throws IOException {
        PropertiesExtensions.toProperties(properties, xml, comment, true);
    }

    public static void toPropertiesFile(OutputStream outputStream, InputStream inputStream, String comment) throws IOException {
        PropertiesExtensions.toProperties(outputStream, inputStream, comment, false);
    }

    public static void toProperties(OutputStream outputStream, InputStream inputStream, String comment, boolean xmlFile) throws IOException {
        PropertiesExtensions.export(null, outputStream, inputStream, comment, xmlFile, false);
    }

    public static void export(Properties properties, OutputStream outputStream, InputStream inputStream, String comment, boolean loadFromXML, boolean storeToXML) throws IOException {
        if (properties == null) {
            properties = new Properties();
        }
        if (inputStream != null) {
            if (loadFromXML) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
        }
        if (storeToXML) {
            properties.storeToXML(outputStream, comment);
        } else {
            properties.store(outputStream, comment);
        }
    }

    public static void export(Properties properties, OutputStream outputStream) throws IOException {
        PropertiesExtensions.export(properties, outputStream, null);
    }

    public static void export(Properties properties, OutputStream outputStream, String comment) throws IOException {
        PropertiesExtensions.export(properties, outputStream, null, comment, false, false);
    }

    public static void toXml(File properties, File xml, String comment, String encoding) throws IOException {
        PropertiesExtensions.toXml(new FileInputStream(properties), new FileOutputStream(xml), comment, encoding);
    }

    public static void toXml(InputStream properties, OutputStream xml, String comment, String encoding) throws IOException {
        Properties prop = new Properties();
        prop.load(properties);
        prop.storeToXML(xml, comment, encoding);
    }

    public static Optional<Integer> getInteger(Properties properties, String propertiesKey) {
        if (properties != null && properties.containsKey(propertiesKey)) {
            String portAsString = properties.getProperty(propertiesKey);
            Integer port = Integer.valueOf(portAsString);
            return Optional.of(port);
        }
        return Optional.empty();
    }

    private PropertiesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

