/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.comparators;

import de.alpharogroup.comparators.ComparatorExtensions;
import de.alpharogroup.comparators.SortOrder;
import java.util.Comparator;

public class SortOrderComparator<T extends Comparable<T>>
implements Comparator<T> {
    public static final SortOrder DEFAULT_SORT_ORDER = SortOrder.ASCENDING;
    private SortOrder sortOrder = SortOrder.ASCENDING;

    public static <T extends Comparable<T>> Comparator<T> of() {
        return new SortOrderComparator<T>();
    }

    public static <T extends Comparable<T>> Comparator<T> of(SortOrder sortOrder) {
        return new SortOrderComparator<T>(sortOrder);
    }

    public SortOrderComparator() {
        this(DEFAULT_SORT_ORDER);
    }

    public SortOrderComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(T object, T compareWithObject) {
        return ComparatorExtensions.compare(object, compareWithObject, this.sortOrder);
    }
}

