/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.comparators;

import de.alpharogroup.comparators.SortOrder;

public final class ComparatorExtensions {
    public static <T extends Comparable<T>> int compare(T object, T compareWithObject) {
        Integer nullCheck = ComparatorExtensions.nullCheck(object, compareWithObject);
        if (nullCheck != null) {
            return nullCheck;
        }
        return object.compareTo(compareWithObject);
    }

    public static <T extends Comparable<T>> int compare(T object, T compareWithObject, SortOrder sortOrder) {
        if (SortOrder.DESCENDING.equals((Object)sortOrder)) {
            return ComparatorExtensions.compare(object, compareWithObject) * -1;
        }
        return ComparatorExtensions.compare(object, compareWithObject);
    }

    public static <T> Boolean equalNullCheck(T object, T compareWithObject) {
        if (object == compareWithObject) {
            return true;
        }
        if (object == null || compareWithObject == null) {
            return false;
        }
        return null;
    }

    public static <T> Integer nullCheck(T object, T compareWithObject) {
        if (object != null && compareWithObject == null) {
            return 1;
        }
        if (object == null && compareWithObject != null) {
            return -1;
        }
        if (object == compareWithObject) {
            return 0;
        }
        return null;
    }

    public static <T> Integer nullCheck(T object, T compareWithObject, boolean nullIsGreaterThan) {
        if (object == compareWithObject) {
            return 0;
        }
        if (object == null) {
            if (nullIsGreaterThan) {
                return 1;
            }
            return -1;
        }
        if (compareWithObject == null) {
            if (nullIsGreaterThan) {
                return -1;
            }
            return 1;
        }
        return null;
    }

    private ComparatorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

