/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner;

import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.jetty9.runner.config.Jetty9RunConfiguration;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class Jetty9Runner {
    public static WebAppContext getWebAppContext(Server server, String projectname) {
        File webapp = PathFinder.getProjectDirectory();
        File wa = PathFinder.getRelativePath((File)webapp, (String[])new String[]{projectname, "src", "main", "webapp"});
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setServer(server);
        webAppContext.setContextPath("/");
        webAppContext.setWar(wa.getAbsolutePath());
        return webAppContext;
    }

    public static void run(Jetty9RunConfiguration config) {
        Server server = new Server();
        Jetty9Runner.run(server, config);
    }

    public static void run(Server server, Jetty9RunConfiguration config) {
        Resource keystore;
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(config.getHttpsPort());
        http_config.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(config.getHttpPort());
        http.setIdleTimeout(3600000L);
        server.addConnector((Connector)http);
        if (config.getKeyStorePathResource() != null && !config.getKeyStorePathResource().isEmpty() && (keystore = Resource.newClassPathResource((String)config.getKeyStorePathResource())) != null && keystore.exists()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStoreResource(keystore);
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(config.getKeyStorePassword());
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)}){};
            https.setPort(config.getHttpsPort());
            https.setIdleTimeout(500000L);
            server.addConnector((Connector)https);
            System.out.println("SSL access to the examples has been enabled on port " + config.getHttpsPort());
            System.out.println("You can access the application using SSL on https://localhost:" + config.getHttpsPort());
            System.out.println();
        }
        if (config.getHandlers() == null) {
            config.setHandlers(new HandlerCollection());
        }
        if (config.getContexts() == null) {
            config.setContexts(new ContextHandlerCollection());
        }
        config.getHandlers().setHandlers(new Handler[]{config.getContexts(), new DefaultHandler()});
        server.setHandler((Handler)config.getHandlers());
        if (config.getDeployer() != null) {
            server.addBean((Object)config.getDeployer());
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanContainer mBeanContainer = new MBeanContainer(mBeanServer);
        server.addEventListener((Container.Listener)mBeanContainer);
        server.addBean((Object)mBeanContainer);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static void run(Server server, ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword, String keyStorePathResource) {
        Jetty9Runner.run(server, Jetty9RunConfiguration.builder().servletContextHandler(servletContextHandler).httpPort(httpPort).httpsPort(httpsPort).keyStorePassword(keyStorePassword).keyStorePathResource(keyStorePathResource).build());
    }

    public static void run(ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword) {
        Server server = new Server();
        Jetty9Runner.run(server, servletContextHandler, httpPort, httpsPort, keyStorePassword, "/keystore");
    }

    public static void runServletContextHandler(Server server, Jetty9RunConfiguration config) {
        Resource keystore;
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(config.getHttpsPort());
        http_config.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(config.getHttpPort());
        http.setIdleTimeout(3600000L);
        server.addConnector((Connector)http);
        if (config.getKeyStorePathResource() != null && !config.getKeyStorePathResource().isEmpty() && (keystore = Resource.newClassPathResource((String)config.getKeyStorePathResource())) != null && keystore.exists()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStoreResource(keystore);
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(config.getKeyStorePassword());
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)}){};
            https.setPort(config.getHttpsPort());
            https.setIdleTimeout(500000L);
            server.addConnector((Connector)https);
            System.out.println("SSL access to the examples has been enabled on port " + config.getHttpsPort());
            System.out.println("You can access the application using SSL on https://localhost:" + config.getHttpsPort());
            System.out.println();
        }
        server.setHandler((Handler)config.getServletContextHandler());
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanContainer mBeanContainer = new MBeanContainer(mBeanServer);
        server.addEventListener((Container.Listener)mBeanContainer);
        server.addBean((Object)mBeanContainer);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static void runWithNewServer(ServletContextHandler servletContextHandler, int httpPort, int httpsPort) {
        Jetty9Runner.runWithNewServer(servletContextHandler, httpPort, httpsPort, "wicket");
    }

    public static void runWithNewServer(ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword) {
        Server server = new Server();
        Jetty9Runner.run(server, servletContextHandler, httpPort, httpsPort, keyStorePassword, "/keystore");
    }
}

