/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner;

import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.jetty9.runner.config.Jetty9RunConfiguration;
import de.alpharogroup.jetty9.runner.config.StartConfig;
import de.alpharogroup.jetty9.runner.factories.ConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public final class Jetty9Runner {
    private static final Logger log = Logger.getLogger(Jetty9Runner.class.getName());
    public static final String HTTPS = "https";

    public static File getLogFile(File projectDirectory, String logFileName) {
        File logfile = new File(projectDirectory, logFileName);
        if (logfile.exists()) {
            try {
                DeleteFileExtensions.delete((File)logfile);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "logfile could not deleted.", e);
            }
        }
        return logfile;
    }

    public static WebAppContext getWebAppContext(Server server, String projectname) {
        File webapp = PathFinder.getProjectDirectory();
        File wa = PathFinder.getRelativePath((File)webapp, (String[])new String[]{projectname, "src", "main", "webapp"});
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setServer(server);
        webAppContext.setContextPath("/");
        webAppContext.setWar(wa.getAbsolutePath());
        return webAppContext;
    }

    public static File getWebappDirectory(File projectDirectory, String projectName) {
        File webapp = projectDirectory.getAbsolutePath().endsWith(projectName) ? PathFinder.getRelativePath((File)projectDirectory, (String[])new String[]{"src", "main", "webapp"}) : PathFinder.getRelativePath((File)projectDirectory, (String[])new String[]{projectName, "src", "main", "webapp"});
        return webapp;
    }

    public static Jetty9RunConfiguration newJetty9RunConfiguration(ServletContextHandler servletContextHandler, ContextHandlerCollection contexts, DeploymentManager deployer, StartConfig startConfig) {
        Jetty9RunConfiguration configuration = Jetty9RunConfiguration.builder().servletContextHandler(servletContextHandler).contexts(contexts).deployer(deployer).httpPort(startConfig.getHttpPort()).httpsPort(startConfig.getHttpsPort()).keyStorePassword(startConfig.getKeyStorePassword()).keyStorePathResource(startConfig.getKeyStorePathResource()).build();
        return configuration;
    }

    public static void run(Jetty9RunConfiguration config) {
        Server server = new Server();
        Jetty9Runner.run(server, config);
    }

    public static void run(Server server, Jetty9RunConfiguration config) {
        HttpConfiguration httpsConfiguration = ConfigurationFactory.newHttpConfiguration((String)HTTPS, (int)config.getHttpsPort(), (int)32768);
        ServerConnector http = ConfigurationFactory.newServerConnector((Server)server, (HttpConfiguration)httpsConfiguration, (int)config.getHttpPort(), (long)3600000L);
        server.addConnector((Connector)http);
        if (config.getKeyStorePathResource() != null && !config.getKeyStorePathResource().isEmpty()) {
            Resource keystore = Resource.newClassPathResource((String)config.getKeyStorePathResource());
            if (keystore != null && keystore.exists()) {
                SslContextFactory sslContextFactory = ConfigurationFactory.newSslContextFactory((Resource)keystore, (String)config.getKeyStorePassword(), (String)config.getKeyStorePassword());
                HttpConfiguration httpsConfig = new HttpConfiguration(httpsConfiguration);
                httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector https = ConfigurationFactory.newServerConnector((Server)server, (SslConnectionFactory)new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), (HttpConfiguration)httpsConfig, (int)config.getHttpsPort(), (long)500000L);
                server.addConnector((Connector)https);
                log.info("***************************************************************************");
                log.info("**  SSL access to the application has been enabled on port " + config.getHttpsPort() + ".         **");
                log.info("**  You can access the application using SSL on https://localhost:" + config.getHttpsPort() + ".  **");
                log.info("***************************************************************************");
            } else {
                log.severe("*****************************************************");
                log.severe("**  Keystore is null. Provide a keystore for ssh.  **");
                log.severe("*****************************************************");
            }
        } else {
            log.info("***************************************************");
            log.info("**  Keystore path is null. You can not use ssh.  **");
            log.info("***************************************************");
        }
        if (config.getHandlers() == null) {
            config.setHandlers(new HandlerCollection());
        }
        if (config.getContexts() == null) {
            config.setContexts(new ContextHandlerCollection());
        }
        config.getHandlers().setHandlers(new Handler[]{config.getContexts(), new DefaultHandler()});
        server.setHandler((Handler)config.getHandlers());
        if (config.getDeployer() != null) {
            server.addBean((Object)config.getDeployer());
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanContainer mBeanContainer = new MBeanContainer(mBeanServer);
        server.addEventListener((Container.Listener)mBeanContainer);
        server.addBean((Object)mBeanContainer);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static void run(Server server, ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword, String keyStorePathResource) {
        Jetty9Runner.run(server, Jetty9RunConfiguration.builder().servletContextHandler(servletContextHandler).httpPort(httpPort).httpsPort(httpsPort).keyStorePassword(keyStorePassword).keyStorePathResource(keyStorePathResource).build());
    }

    public static void run(ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword) {
        Server server = new Server();
        Jetty9Runner.run(server, servletContextHandler, httpPort, httpsPort, keyStorePassword, "/keystore");
    }

    public static void run(StartConfig startConfig, Server server) {
        if (startConfig.getLogFile().exists()) {
            try {
                DeleteFileExtensions.delete((File)startConfig.getLogFile());
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "logfile could not deleted.", e);
            }
        }
    }

    public static void runServletContextHandler(Server server, Jetty9RunConfiguration config) {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme(HTTPS);
        http_config.setSecurePort(config.getHttpsPort());
        http_config.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(config.getHttpPort());
        http.setIdleTimeout(3600000L);
        server.addConnector((Connector)http);
        if (config.getKeyStorePathResource() != null && !config.getKeyStorePathResource().isEmpty()) {
            Resource keystore = Resource.newClassPathResource((String)config.getKeyStorePathResource());
            if (keystore != null && keystore.exists()) {
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStoreResource(keystore);
                sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
                sslContextFactory.setKeyManagerPassword(config.getKeyStorePassword());
                HttpConfiguration https_config = new HttpConfiguration(http_config);
                https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)}){};
                https.setPort(config.getHttpsPort());
                https.setIdleTimeout(500000L);
                server.addConnector((Connector)https);
                log.info("***************************************************************************");
                log.info("**  SSL access to the application has been enabled on port " + config.getHttpsPort() + ".         **");
                log.info("**  You can access the application using SSL on https://localhost:" + config.getHttpsPort() + ".  **");
                log.info("***************************************************************************");
            } else {
                log.severe("*****************************************************");
                log.severe("**  Keystore is null. Provide a keystore for ssh.  **");
                log.severe("*****************************************************");
            }
        } else {
            log.info("***************************************************");
            log.info("**  Keystore path is null. You can not use ssh.  **");
            log.info("***************************************************");
        }
        server.setHandler((Handler)config.getServletContextHandler());
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanContainer mBeanContainer = new MBeanContainer(mBeanServer);
        server.addEventListener((Container.Listener)mBeanContainer);
        server.addBean((Object)mBeanContainer);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static void runWithNewServer(ServletContextHandler servletContextHandler, int httpPort, int httpsPort) {
        Jetty9Runner.runWithNewServer(servletContextHandler, httpPort, httpsPort, "wicket");
    }

    public static void runWithNewServer(ServletContextHandler servletContextHandler, int httpPort, int httpsPort, String keyStorePassword) {
        Server server = new Server();
        Jetty9Runner.run(server, servletContextHandler, httpPort, httpsPort, keyStorePassword, "/keystore");
    }

    private Jetty9Runner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

