/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.filter;

import de.alpharogroup.collections.array.ArrayExtensions;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MultiplyExtensionsFileFilter
implements FileFilter {
    private Set<String> fileExtensions;
    private boolean acceptDir;

    public MultiplyExtensionsFileFilter(boolean acceptDir, String ... fileExtensions) {
        this(ArrayExtensions.toList((Object[])fileExtensions), acceptDir);
    }

    public MultiplyExtensionsFileFilter(Collection<String> fileExtensions) {
        this(fileExtensions, false);
    }

    public MultiplyExtensionsFileFilter(Collection<String> fileExtensions, boolean acceptDir) {
        if (null == fileExtensions || fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Argument fileExtensions cant be null or empty. Please set the argument fileExtensions appropriate.");
        }
        this.acceptDir = acceptDir;
        this.fileExtensions = new HashSet<String>(fileExtensions.size());
        for (String extension : fileExtensions) {
            this.fileExtensions.add(extension.toLowerCase());
        }
    }

    public MultiplyExtensionsFileFilter(String ... fileExtensions) {
        this(false, fileExtensions);
    }

    @Override
    public boolean accept(File pathname) {
        if (this.acceptDir && pathname.isDirectory()) {
            return true;
        }
        String filename = pathname.getName();
        for (String extension : this.fileExtensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[MultiplyExtensionsFileFilter:");
        buffer.append(" fileExtensions: ");
        buffer.append(this.fileExtensions);
        buffer.append(" acceptDir: ");
        buffer.append(this.acceptDir);
        buffer.append("]");
        return buffer.toString();
    }
}

