/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file;

import java.io.File;

public final class FilenameExtensions {
    public static String getFilenamePrefix(File file) {
        String fileName = file.getAbsolutePath();
        int ext_index = fileName.lastIndexOf(".");
        String fileNamePrefix = ext_index != -1 ? fileName.substring(0, ext_index) : fileName;
        return fileNamePrefix;
    }

    public static String getFilenameSuffix(File file) {
        if (!file.isDirectory()) {
            String fileName = file.getAbsolutePath();
            int ext_index = fileName.lastIndexOf(".");
            String fileNameSuffix = ext_index != -1 ? fileName.substring(ext_index, fileName.length()) : null;
            return fileNameSuffix;
        }
        return null;
    }

    public static String getFilenameWithoutExtension(File file) {
        if (!file.isDirectory()) {
            String fileName = file.getName();
            return FilenameExtensions.getFilenameWithoutExtension(fileName);
        }
        return null;
    }

    public static String getFilenameWithoutExtension(String fileName) {
        int ext_index = fileName.lastIndexOf(".");
        String fileNamePrefix = ext_index != -1 ? fileName.substring(0, ext_index) : fileName;
        return fileNamePrefix;
    }

    private FilenameExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

