/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.i18n.list;

import de.alpharogroup.resourcebundle.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.link.LinkItem;
import de.alpharogroup.wicket.components.listview.ListViewPanel;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LinkListPanel
extends ListViewPanel<LinkItem> {
    private static final long serialVersionUID = 1L;

    public LinkListPanel(String id, IModel<List<LinkItem>> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public LinkListPanel(String id, List<LinkItem> list) {
        super(id, list);
        this.setOutputMarkupId(true);
    }

    protected String getCurrentPageCssClass() {
        return "current-page";
    }

    protected AbstractLink newAbstractLink(String id, LinkItem model) {
        AttributeModifier target = null;
        ExternalLink link = null;
        if (model.getTarget() != null && !model.getTarget().isEmpty()) {
            target = new AttributeModifier("target", (IModel)Model.of((Serializable)((Object)model.getTarget())));
        }
        if (model.getUrl() != null) {
            link = new ExternalLink(id, (IModel)Model.of((Serializable)((Object)model.getUrl())));
        }
        if (link == null) {
            link = new BookmarkablePageLink(id, model.getPageClass());
        }
        if (target != null) {
            link.add(new Behavior[]{target});
        }
        link.setOutputMarkupId(true);
        return link;
    }

    protected Label newItemLinkLabel(String id, LinkItem model) {
        Label itemLinkLabel = ComponentFactory.newLabel(id, ResourceModelFactory.newResourceModel((ResourceBundleKey)model.getResourceModelKey(), (Component)this));
        if (model.getPageClass() != null && model.getPageClass().equals(this.getPage().getClass())) {
            itemLinkLabel.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)(" " + this.getCurrentPageCssClass())))});
        }
        return itemLinkLabel;
    }

    @Override
    protected Component newListComponent(String id, ListItem<LinkItem> item) {
        LinkItem model = (LinkItem)item.getModelObject();
        Label itemLinkLabel = this.newItemLinkLabel("itemLinkLabel", model);
        AbstractLink link = this.newAbstractLink(id, model);
        link.add(new Component[]{itemLinkLabel});
        return link;
    }
}

