/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.textarea;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.ComponentFinder;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.label.LabeledMultiLineLabelPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.swap.ModeContext;
import de.alpharogroup.wicket.components.swap.SwapComponentsFragmentPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;

public class EditableTextArea
extends BasePanel<String> {
    private static final long serialVersionUID = 1L;
    private ModeContext modeContext = ModeContext.VIEW_MODE;
    private SwapComponentsFragmentPanel<String> swapPanel;
    private final IModel<String> labelModel;
    private MultiLineLabel label;
    private TextArea<String> textArea;

    public EditableTextArea(String id, IModel<String> model, IModel<String> labelModel) {
        this(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public EditableTextArea(String id, IModel<String> model, IModel<String> labelModel, ModeContext modeContext) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.labelModel = labelModel;
        this.modeContext = modeContext;
    }

    public boolean isEditable() {
        return this.modeContext.equals((Object)ModeContext.EDIT_MODE);
    }

    protected MultiLineLabel newMultiLineLabel(String id, IModel<String> model) {
        MultiLineLabel multiLineLabel = new MultiLineLabel(id, model){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                this.setVisibilityAllowed(!EditableTextArea.this.isEditable());
            }
        };
        multiLineLabel.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        return multiLineLabel;
    }

    protected TextArea<String> newTextArea(String id, IModel<String> model) {
        TextArea<String> textArea = new TextArea<String>(id, model){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                this.setVisibilityAllowed(EditableTextArea.this.isEditable());
            }
        };
        textArea.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        return textArea;
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.swapPanel = new SwapComponentsFragmentPanel<String>("swapPanel", this.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newEditComponent(String id, IModel<String> model) {
                return new LabeledTextAreaPanel<String, String>(id, model, EditableTextArea.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected TextArea<String> newTextArea(String id, IModel<String> model) {
                        return ComponentFactory.newTextArea(id, model);
                    }
                };
            }

            @Override
            protected Component newViewComponent(String id, IModel<String> model) {
                return new LabeledMultiLineLabelPanel<String>(id, model, EditableTextArea.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected MultiLineLabel newMultiLineLabelLabel(String id, IModel<String> model) {
                        return ComponentFactory.newMultiLineLabel(id, model);
                    }
                };
            }
        };
        componentArray[0] = this.swapPanel;
        this.add(componentArray);
        if (this.modeContext.equals((Object)ModeContext.EDIT_MODE)) {
            this.swapPanel.onSwapToEdit(ComponentFinder.findOrCreateNewAjaxRequestTarget(), null);
        }
    }

    public void swap() {
        this.modeContext = this.modeContext.equals((Object)ModeContext.VIEW_MODE) ? ModeContext.EDIT_MODE : ModeContext.VIEW_MODE;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public void setModeContext(ModeContext modeContext) {
        this.modeContext = modeContext;
    }

    public SwapComponentsFragmentPanel<String> getSwapPanel() {
        return this.swapPanel;
    }

    public IModel<String> getLabelModel() {
        return this.labelModel;
    }

    public MultiLineLabel getLabel() {
        return this.label;
    }

    public TextArea<String> getTextArea() {
        return this.textArea;
    }
}

