/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.swap;

import de.alpharogroup.wicket.components.swap.ModeContext;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class SwapFragmentPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger((String)SwapFragmentPanel.class.getName());
    private static final String FRAGMENT_ID = "fragment-placeholder";
    private Fragment view;
    private Fragment edit;
    private ModeContext modeContext = ModeContext.VIEW_MODE;

    public SwapFragmentPanel(String id, IModel<T> model) {
        super(id, (IModel)Args.notNull(model, (String)"model"));
        this.setOutputMarkupPlaceholderTag(true);
        Component[] componentArray = new Component[1];
        this.view = this.newViewFragment(FRAGMENT_ID);
        componentArray[0] = this.view;
        this.add(componentArray);
        this.edit = this.newEditFragment(FRAGMENT_ID);
    }

    protected abstract Fragment newEditFragment(String var1);

    protected abstract Fragment newViewFragment(String var1);

    public void onSwapToEdit(AjaxRequestTarget target, Form<?> form) {
        this.swapFragments();
        if (target != null) {
            target.add(new Component[]{this.view});
        } else {
            LOGGER.error((Object)"AjaxRequestTarget is null on method SwapFragmentPanel#onSwapToEdit(AjaxRequestTarget, Form)");
        }
        this.modeContext = ModeContext.EDIT_MODE;
    }

    public void onSwapToView(AjaxRequestTarget target, Form<?> form) {
        if (target != null) {
            target.add(new Component[]{this.edit});
        } else {
            LOGGER.error((Object)"AjaxRequestTarget is null on method SwapFragmentPanel#onSwapToView(AjaxRequestTarget, Form)");
        }
        this.swapFragments();
        this.modeContext = ModeContext.VIEW_MODE;
    }

    private void swapFragments() {
        Fragment fragment = this.view;
        this.view.replaceWith((Component)this.edit);
        this.view = this.edit;
        this.edit = fragment;
    }

    protected void swapFragments(AjaxRequestTarget target, Form<?> form) {
        if (this.modeContext.equals((Object)ModeContext.VIEW_MODE)) {
            this.onSwapToEdit(target, form);
        } else {
            this.onSwapToView(target, form);
        }
    }

    public Fragment getView() {
        return this.view;
    }

    public Fragment getEdit() {
        return this.edit;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }
}

