/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.link;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public abstract class LinkPanel
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    private final AbstractLink link;
    private final Component label;
    private final Form<?> form;

    public LinkPanel(String id, IModel<String> labelModel) {
        this(id, labelModel, null);
    }

    public LinkPanel(String id, IModel<String> labelModel, Form<?> form) {
        super(id, labelModel);
        this.form = form;
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.link = this.newLink("link");
        componentArray[0] = this.link;
        this.add(componentArray);
        this.label = this.newLabel("label", labelModel);
        this.link.add(new Component[]{this.label});
    }

    protected Label newLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected AbstractLink newLink(String id) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                LinkPanel.this.onClick(target);
            }
        };
    }

    public abstract void onClick(AjaxRequestTarget var1);

    public AbstractLink getLink() {
        return this.link;
    }

    public Component getLabel() {
        return this.label;
    }

    public Form<?> getForm() {
        return this.form;
    }
}

