/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.imprint;

import de.alpharogroup.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.imprint.ImprintModel;
import de.alpharogroup.wicket.components.mailto.MailToPanel;
import de.alpharogroup.wicket.components.termofuse.disclaimer.DisclaimerPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class ImprintPanel
extends BasePanel<ImprintModel> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer disclaimerContainer;
    private final WebMarkupContainer imprintContainer;

    public ImprintPanel(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.imprintContainer = this.newImprintContainer("imprintContainer");
        componentArray[0] = this.imprintContainer;
        this.add(componentArray);
        Object[] domainNameParams = new Object[]{this.getDomainName()};
        this.imprintContainer.add(new Component[]{new Label("imprintHeaderLbl", this.newImprintHeaderModel())});
        this.imprintContainer.add(new Component[]{new Label("urlWithSloganLbl", this.newSloganModel(domainNameParams))});
        this.imprintContainer.add(new Component[]{new Label("serviceFromLbl", this.newServiceFromModel())});
        this.imprintContainer.add(new Component[]{new Label("companyNameLbl", this.newCompanyNameModel())});
        this.imprintContainer.add(new Component[]{new Label("streetAndNumberLbl", this.newStreetAndNumberModel())});
        this.imprintContainer.add(new Component[]{new Label("zipAndCityLbl", this.newZipAndCityModel())});
        this.imprintContainer.add(new Component[]{new Label("state", this.newStateModel())});
        this.imprintContainer.add(new Component[]{new Label("authRepresentLabel", this.newAuthRepresentLabelModel())});
        this.imprintContainer.add(new Component[]{new Label("authRepresentContent", this.newAuthRepresentContentModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterEntryHeader", this.newCompanyRegisterEntryHeaderModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterEntryContent", this.newCompanyRegisterEntryContentModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterEntryNumber", this.newCompanyRegisterEntryNumberModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationHeader", this.newCompanyRegisterIndedificationHeaderModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationContent", this.newCompanyRegisterIndedificationContentModel())});
        this.imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationNumber", this.newCompanyRegisterEntryNumberModel())});
        this.imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterHeader", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.header.label").defaultValue("").build(), (Component)this))});
        this.imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterContent", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.label").defaultValue("").build(), (Component)this))});
        this.imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterNumber", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.number").defaultValue("").build(), (Component)this))});
        this.disclaimerContainer = this.newDisclaimerContainer("disclaimerContainer");
        this.add(new Component[]{this.disclaimerContainer});
        this.disclaimerContainer.add(new Component[]{new DisclaimerPanel("disclaimerPanel")});
        this.disclaimerContainer.add(new Component[]{new MailToPanel("mailToPanel"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getDomainName() {
                return ImprintPanel.this.getDomainName();
            }
        }});
    }

    protected abstract String getDomainName();

    protected IModel<String> newAuthRepresentContentModel() {
        return this.newIModel("main.global.company.authorised.representative");
    }

    protected IModel<String> newAuthRepresentLabelModel() {
        return this.newIModel("main.global.company.authorised.representative.label");
    }

    protected IModel<String> newCompanyNameModel() {
        return this.newIModel("main.global.company.name.label");
    }

    protected IModel<String> newCompanyRegisterEntryContentModel() {
        return this.newIModel("main.global.company.register.entry.label");
    }

    protected IModel<String> newCompanyRegisterEntryHeaderModel() {
        return this.newIModel("main.global.company.register.entry.header.label");
    }

    protected IModel<String> newCompanyRegisterEntryNumberModel() {
        return this.newIModel("main.global.company.register.entry.court.number");
    }

    protected IModel<String> newCompanyRegisterIndedificationContentModel() {
        return this.newIModel("main.global.company.register.identification.label");
    }

    protected IModel<String> newCompanyRegisterIndedificationHeaderModel() {
        return this.newIModel("main.global.company.register.identification.header.label");
    }

    protected WebMarkupContainer newDisclaimerContainer(String id) {
        return ComponentFactory.newWebMarkupContainer(id);
    }

    protected IModel<String> newIModel(String key) {
        return ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key(key).defaultValue("").build(), (Component)this);
    }

    protected WebMarkupContainer newImprintContainer(String id) {
        return ComponentFactory.newWebMarkupContainer(id);
    }

    protected IModel<String> newImprintHeaderModel() {
        return this.newIModel("main.global.company.masthead.label");
    }

    protected IModel<String> newServiceFromModel() {
        return this.newIModel("imprint.service.from.label");
    }

    protected IModel<String> newSloganModel(Object[] domainNameParams) {
        return ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.url.and.slogan.label").parameters(domainNameParams).defaultValue("").build(), (Component)this);
    }

    protected IModel<String> newStateModel() {
        return this.newIModel("main.global.company.state.label");
    }

    protected IModel<String> newStreetAndNumberModel() {
        return this.newIModel("main.global.company.street.and.number.label");
    }

    protected IModel<String> newZipAndCityModel() {
        return this.newIModel("main.global.company.zipcode.and.city.label");
    }

    public WebMarkupContainer getDisclaimerContainer() {
        return this.disclaimerContainer;
    }

    public WebMarkupContainer getImprintContainer() {
        return this.imprintContainer;
    }
}

