/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.form.checkbox;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.form.checkbox.CheckboxModelBean;
import java.io.Serializable;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.wicketeer.modelfactory.ModelFactory;

public class CheckGroupSelectorPanel<T>
extends BasePanel<CheckboxModelBean<T>> {
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private final CheckGroup<T> checkGroup;
    private final CheckGroupSelector checkGroupSelector;
    private final Label checkGroupSelectorLabel;
    private final ListView<T> choices;

    public CheckGroupSelectorPanel(String id, IModel<CheckboxModelBean<T>> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.checkGroup = this.newCheckGroup("checkGroup", ModelFactory.model(((CheckboxModelBean)ModelFactory.from(model)).getSelectedItems()));
        componentArray2[0] = this.checkGroup;
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.checkGroupSelector = this.newCheckGroupSelector("checkGroupSelector", this.checkGroup);
        componentArray3[0] = this.checkGroupSelector;
        this.checkGroup.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.checkGroupSelectorLabel = this.newCheckGroupSelectorLabel("checkGroupSelectorLabel", this.checkGroupSelector.getMarkupId(), (IModel<String>)Model.of((Serializable)((Object)"check/uncheck all")));
        componentArray4[0] = this.checkGroupSelectorLabel;
        this.checkGroup.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.choices = this.newChoices("choices", model);
        componentArray5[0] = this.choices;
        this.checkGroup.add(componentArray5);
    }

    protected CheckGroup<T> newCheckGroup(String id, IModel<? extends Collection<T>> model) {
        CheckGroup checkGroup = ComponentFactory.newCheckGroup(id, model);
        checkGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                CheckGroupSelectorPanel.this.onUpdate(target);
            }
        }});
        return checkGroup;
    }

    protected CheckGroupSelector newCheckGroupSelector(String id, CheckGroup<T> group) {
        return ComponentFactory.newCheckGroupSelector(id, group);
    }

    protected Label newCheckGroupSelectorLabel(String id, String forId, IModel<String> model) {
        return ComponentFactory.newLabel(id, forId, model);
    }

    protected ListView<T> newChoices(String id, final IModel<CheckboxModelBean<T>> model) {
        ListView choices = new ListView<T>("choices", ((CheckboxModelBean)model.getObject()).getChoices()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                item.add(new Component[]{new Check("checkbox", item.getModel())});
                item.add(new Component[]{new Label("label", (IModel)new PropertyModel((Object)item.getDefaultModel(), ((CheckboxModelBean)model.getObject()).getLabelPropertyExpression()))});
            }
        };
        choices.setReuseItems(true);
        return choices;
    }

    protected Form<?> newForm(String id) {
        return ComponentFactory.newForm(id);
    }

    protected void onUpdate(AjaxRequestTarget target) {
    }

    public Form<?> getForm() {
        return this.form;
    }

    public CheckGroup<T> getCheckGroup() {
        return this.checkGroup;
    }

    public CheckGroupSelector getCheckGroupSelector() {
        return this.checkGroupSelector;
    }

    public Label getCheckGroupSelectorLabel() {
        return this.checkGroupSelectorLabel;
    }

    public ListView<T> getChoices() {
        return this.choices;
    }
}

