/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.textfield;

import de.alpharogroup.wicket.base.util.ComponentFinder;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.label.LabeledLabelPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import de.alpharogroup.wicket.components.swap.ModeContext;
import de.alpharogroup.wicket.components.swap.SwapComponentsFragmentPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public class EditableTextField
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    private ModeContext modeContext = ModeContext.VIEW_MODE;
    private SwapComponentsFragmentPanel<String> swapPanel;
    private final IModel<String> labelModel;

    public EditableTextField(String id, IModel<String> model, IModel<String> labelModel) {
        this(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public EditableTextField(String id, IModel<String> model, IModel<String> labelModel, ModeContext modeContext) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.labelModel = labelModel;
        this.modeContext = modeContext;
    }

    public boolean isEditable() {
        return this.modeContext.equals((Object)ModeContext.EDIT_MODE);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.swapPanel = new SwapComponentsFragmentPanel<String>("swapPanel", this.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newEditComponent(String id, IModel<String> model) {
                return new LabeledTextFieldPanel<String>(id, model, EditableTextField.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected TextField<String> newTextField(String id, IModel<String> model) {
                        return ComponentFactory.newTextField(id, model);
                    }
                };
            }

            @Override
            protected Component newViewComponent(String id, IModel<String> model) {
                return new LabeledLabelPanel<String>(id, model, EditableTextField.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Label newLabel(String id, IModel<String> model) {
                        return ComponentFactory.newLabel(id, model);
                    }
                };
            }
        };
        componentArray[0] = this.swapPanel;
        this.add(componentArray);
        if (this.modeContext.equals((Object)ModeContext.EDIT_MODE)) {
            this.swapPanel.onSwapToEdit(ComponentFinder.findOrCreateNewAjaxRequestTarget(), null);
        }
    }

    public void swap() {
        this.modeContext = this.modeContext.equals((Object)ModeContext.VIEW_MODE) ? ModeContext.EDIT_MODE : ModeContext.VIEW_MODE;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public void setModeContext(ModeContext modeContext) {
        this.modeContext = modeContext;
    }

    public SwapComponentsFragmentPanel<String> getSwapPanel() {
        return this.swapPanel;
    }

    public IModel<String> getLabelModel() {
        return this.labelModel;
    }
}

