/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.ajax.editable.tabs;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.model.IModel;

public class EditableAjaxTabbedPanel<T extends ITab>
extends AjaxTabbedPanel<T> {
    private static final long serialVersionUID = 1L;

    public EditableAjaxTabbedPanel(String id, List<T> tabs) {
        super(id, tabs);
    }

    public EditableAjaxTabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, tabs, model);
    }

    public void onNewTab(AjaxRequestTarget target, T tab) {
        this.getTabs().add(tab);
        this.setSelectedTab(this.getTabs().size() - 1);
        target.add(new Component[]{this});
    }

    public void onNewTab(AjaxRequestTarget target, T tab, int index) {
        if (index < 0 || index >= this.getTabs().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.getTabs().add(index, tab);
        this.setSelectedTab(index);
        target.add(new Component[]{this});
    }

    public void onRemoveTab(AjaxRequestTarget target, int index) {
        int tabSize = this.getTabs().size();
        if (2 <= tabSize && index < tabSize) {
            this.setSelectedTab(index);
            this.getTabs().remove(index);
            target.add(new Component[]{this});
        }
    }

    public void onRemoveTab(AjaxRequestTarget target, T tab) {
        int index = this.getTabs().indexOf(tab);
        if (0 <= index) {
            this.onRemoveTab(target, index);
        }
    }
}

