/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.ajax.editable.tabs;

import de.alpharogroup.wicket.components.ajax.editable.tabs.ICloseableTab;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public abstract class AjaxAddableTabbedPanel<T extends ICloseableTab>
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private final List<T> tabs;
    private int currentTab = -1;
    private transient VisibilityCache visibilityCache;
    private WebMarkupContainer tabsUlContainer;
    private WebMarkupContainer tabsContainer;
    private Loop tabsLoop;

    public AjaxAddableTabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public AjaxAddableTabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.tabs = (List)Args.notNull(tabs, (String)"tabs");
        AbstractReadOnlyModel<Integer> tabCount = new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AjaxAddableTabbedPanel.this.tabs.size();
            }
        };
        this.tabsContainer = this.newTabsContainer("tabs-container");
        this.add(new Component[]{this.tabsContainer});
        this.tabsUlContainer = this.newTabsContainer("tabs-ul-container");
        this.tabsContainer.add(new Component[]{this.tabsUlContainer});
        Component[] componentArray = new Component[1];
        this.tabsLoop = this.newTabsLoop("tabs", (IModel<Integer>)tabCount);
        componentArray[0] = this.tabsLoop;
        this.tabsUlContainer.add(componentArray);
        this.tabsUlContainer.add(new Component[]{this.newAddTab("add-tab-container", this.newAddTabLabelModel())});
        this.add(new Component[]{this.newPanel()});
    }

    protected String getLastTabCssClass() {
        return "last";
    }

    public final int getSelectedTab() {
        return (Integer)this.getDefaultModelObject();
    }

    protected String getSelectedTabCssClass() {
        return "selected";
    }

    protected String getTabContainerCssClass() {
        return "tab-row";
    }

    public final List<T> getTabs() {
        return this.tabs;
    }

    private VisibilityCache getVisiblityCache() {
        if (this.visibilityCache == null) {
            this.visibilityCache = new VisibilityCache();
        }
        return this.visibilityCache;
    }

    protected IModel<?> initModel() {
        return new Model((Serializable)Integer.valueOf(-1));
    }

    protected abstract Component newAddTab(String var1, IModel<String> var2);

    protected Label newAddTabButtonLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected abstract Label newaddTabLabel(String var1, IModel<String> var2);

    protected abstract IModel<String> newAddTabLabelModel();

    protected abstract Component newAddTabModalWindow(String var1, IModel<String> var2);

    protected WebMarkupContainer newCloseLink(String linkId, final int index) {
        return new AjaxFallbackLink<Void>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                if (target != null) {
                    AjaxAddableTabbedPanel.this.onRemoveTab(target, index);
                }
                AjaxAddableTabbedPanel.this.onAjaxUpdate(target);
            }
        };
    }

    protected Component newCloseTitle(String titleId, IModel<?> titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new AjaxFallbackLink<Void>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                AjaxAddableTabbedPanel.this.setSelectedTab(index);
                if (target != null) {
                    target.add(new Component[]{AjaxAddableTabbedPanel.this});
                }
                AjaxAddableTabbedPanel.this.onAjaxUpdate(target);
            }
        };
    }

    private WebMarkupContainer newPanel() {
        return new WebMarkupContainer(TAB_PANEL_ID);
    }

    protected LoopItem newTabContainer(final int tabIndex) {
        return new LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = tag.getAttribute("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIndex();
                if (this.getIndex() == AjaxAddableTabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + ' ' + AjaxAddableTabbedPanel.this.getSelectedTabCssClass();
                }
                if (AjaxAddableTabbedPanel.this.getVisiblityCache().getLastVisible() == this.getIndex()) {
                    cssClass = cssClass + ' ' + AjaxAddableTabbedPanel.this.getLastTabCssClass();
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(AjaxAddableTabbedPanel.this.getVisiblityCache().isVisible(tabIndex));
            }
        };
    }

    protected WebMarkupContainer newTabsContainer(String id) {
        WebMarkupContainer wmc = new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)AjaxAddableTabbedPanel.this.getTabContainerCssClass());
            }
        };
        wmc.setOutputMarkupId(true);
        return wmc;
    }

    protected Loop newTabsLoop(String id, IModel<Integer> model) {
        Loop localTabsLoop = new Loop(id, model){
            private static final long serialVersionUID = 1L;

            protected LoopItem newItem(int iteration) {
                return AjaxAddableTabbedPanel.this.newTabContainer(iteration);
            }

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ICloseableTab tab = (ICloseableTab)AjaxAddableTabbedPanel.this.tabs.get(index);
                WebMarkupContainer titleCloseLink = AjaxAddableTabbedPanel.this.newCloseLink("closeTab", index);
                titleCloseLink.add(new Component[]{AjaxAddableTabbedPanel.this.newCloseTitle("closeTitle", tab.getCloseTitle(), index)});
                item.add(new Component[]{titleCloseLink});
                WebMarkupContainer titleLink = AjaxAddableTabbedPanel.this.newLink("link", index);
                titleLink.add(new Component[]{AjaxAddableTabbedPanel.this.newTitle("title", tab.getTitle(), index)});
                item.add(new Component[]{titleLink});
                item.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" label"))});
            }
        };
        localTabsLoop.setOutputMarkupId(true);
        return localTabsLoop;
    }

    protected Component newTitle(String titleId, IModel<?> titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected void onAjaxUpdate(AjaxRequestTarget target) {
    }

    protected void onBeforeRender() {
        int index = this.getSelectedTab();
        if (index == -1 || !this.getVisiblityCache().isVisible(index)) {
            index = -1;
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (!this.getVisiblityCache().isVisible(i)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.setSelectedTab(index);
            }
        }
        this.setCurrentTab(index);
        super.onBeforeRender();
    }

    protected void onDetach() {
        this.visibilityCache = null;
        super.onDetach();
    }

    public void onNewTab(AjaxRequestTarget target, T tab) {
        this.getTabs().add(tab);
        this.setSelectedTab(this.getTabs().size() - 1);
        target.add(new Component[]{this});
    }

    public void onNewTab(AjaxRequestTarget target, T tab, int index) {
        if (index < 0 || index >= this.getTabs().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.getTabs().add(index, tab);
        this.setSelectedTab(index);
        target.add(new Component[]{this});
    }

    public void onRemoveTab(AjaxRequestTarget target, int index) {
        int tabSize = this.getTabs().size();
        if (2 <= tabSize && index < tabSize) {
            this.setSelectedTab(index);
            this.getTabs().remove(index);
            target.add(new Component[]{this});
        }
    }

    public void onRemoveTab(AjaxRequestTarget target, T tab) {
        int index = this.getTabs().indexOf(tab);
        if (0 <= index) {
            this.onRemoveTab(target, index);
        }
    }

    private void setCurrentTab(int index) {
        WebMarkupContainer component;
        if (this.currentTab == index) {
            return;
        }
        this.currentTab = index;
        if (this.currentTab == -1 || this.tabs.isEmpty() || !this.getVisiblityCache().isVisible(this.currentTab)) {
            component = this.newPanel();
        } else {
            ICloseableTab tab = (ICloseableTab)this.tabs.get(this.currentTab);
            component = tab.getPanel(TAB_PANEL_ID);
            if (component == null) {
                throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
            }
        }
        if (!component.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + component.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
        }
        this.addOrReplace(new Component[]{component});
    }

    public AjaxAddableTabbedPanel<T> setSelectedTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setDefaultModelObject(index);
        this.currentTab = -1;
        this.setCurrentTab(index);
        return this;
    }

    public WebMarkupContainer getTabsUlContainer() {
        return this.tabsUlContainer;
    }

    public WebMarkupContainer getTabsContainer() {
        return this.tabsContainer;
    }

    public Loop getTabsLoop() {
        return this.tabsLoop;
    }

    private class VisibilityCache {
        private Boolean[] visibilities;
        private int lastVisible = -1;

        public VisibilityCache() {
            this.visibilities = new Boolean[AjaxAddableTabbedPanel.this.tabs.size()];
        }

        public int getLastVisible() {
            if (this.lastVisible == -1) {
                for (int t = 0; t < AjaxAddableTabbedPanel.this.tabs.size(); ++t) {
                    if (!this.isVisible(t)) continue;
                    this.lastVisible = t;
                }
            }
            return this.lastVisible;
        }

        public boolean isVisible(int index) {
            if (this.visibilities.length < index + 1) {
                Boolean[] resized = new Boolean[index + 1];
                System.arraycopy(this.visibilities, 0, resized, 0, this.visibilities.length);
                this.visibilities = resized;
            }
            if (this.visibilities.length > 0) {
                Boolean visible = this.visibilities[index];
                if (visible == null) {
                    if (index == 1 && index == AjaxAddableTabbedPanel.this.tabs.size()) {
                        this.visibilities[0] = visible = Boolean.valueOf(((ICloseableTab)AjaxAddableTabbedPanel.this.tabs.get(0)).isVisible());
                        return visible;
                    }
                    this.visibilities[index] = visible = Boolean.valueOf(((ICloseableTab)AjaxAddableTabbedPanel.this.tabs.get(index)).isVisible());
                }
                return visible;
            }
            return false;
        }
    }
}

