/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.export.excel.poi;

import de.alpharogroup.lang.ClassExtensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class ExportExcelExtensions {
    public static List<String[][]> exportWorkbook(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<String[][]> sheetList = new ArrayList<String[][]>();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            String[][] excelSheetInTDArray = null;
            excelSheetInTDArray = new String[rows + 1][columns];
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                for (int j = 0; j < columns; ++j) {
                    HSSFCell cell = row.getCell(j);
                    if (null == cell) {
                        excelSheetInTDArray[i][j] = "";
                        continue;
                    }
                    int cellType = cell.getCellType();
                    if (cellType == 3) {
                        excelSheetInTDArray[i][j] = "";
                        continue;
                    }
                    if (cellType == 4) {
                        excelSheetInTDArray[i][j] = Boolean.toString(cell.getBooleanCellValue());
                        continue;
                    }
                    if (cellType == 5) {
                        excelSheetInTDArray[i][j] = "";
                        continue;
                    }
                    if (cellType == 2) {
                        excelSheetInTDArray[i][j] = cell.getCellFormula();
                        continue;
                    }
                    if (cellType == 0) {
                        excelSheetInTDArray[i][j] = Double.toString(cell.getNumericCellValue());
                        continue;
                    }
                    if (cellType != 1) continue;
                    excelSheetInTDArray[i][j] = cell.getRichStringCellValue().getString();
                }
            }
            sheetList.add(excelSheetInTDArray);
        }
        wb.close();
        return sheetList;
    }

    public static List<List<List<String>>> exportWorkbookAsStringList(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<List<List<String>>> sl = new ArrayList<List<List<String>>>();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            ArrayList excelSheetList = new ArrayList();
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                ArrayList<String> reihe = new ArrayList<String>();
                for (int j = 0; j < columns; ++j) {
                    HSSFCell cell = row.getCell(j);
                    if (null == cell) {
                        reihe.add("");
                        continue;
                    }
                    int cellType = cell.getCellType();
                    if (cellType == 3) {
                        reihe.add("");
                        continue;
                    }
                    if (cellType == 4) {
                        reihe.add(Boolean.toString(cell.getBooleanCellValue()));
                        continue;
                    }
                    if (cellType == 5) {
                        reihe.add("");
                        continue;
                    }
                    if (cellType == 2) {
                        reihe.add(cell.getCellFormula());
                        continue;
                    }
                    if (cellType == 0) {
                        reihe.add(Double.toString(cell.getNumericCellValue()));
                        continue;
                    }
                    if (cellType != 1) continue;
                    reihe.add(cell.getRichStringCellValue().getString());
                }
                excelSheetList.add(reihe);
            }
            sl.add(excelSheetList);
        }
        wb.close();
        return sl;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, URISyntaxException {
        String filename = "test.xls";
        URL url = ClassExtensions.getResource((String)"test.xls");
        File excelSheet = new File(url.toURI());
        System.out.println(excelSheet.exists());
        List<String[][]> sheetList = ExportExcelExtensions.exportWorkbook(excelSheet);
        System.out.println(sheetList);
        List<List<List<String>>> excelSheetList = ExportExcelExtensions.exportWorkbookAsStringList(excelSheet);
        System.out.println(excelSheetList);
    }

    public static HSSFWorkbook replaceNullCellsIntoEmptyCells(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                for (int j = 0; j < columns; ++j) {
                    HSSFCell cell = row.getCell(j);
                    if (cell != null) continue;
                    cell = row.createCell(j, 3);
                }
            }
        }
        return wb;
    }

    private ExportExcelExtensions() {
    }
}

