/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.rename;

import de.alpharogroup.file.copy.CopyFileExtensions;
import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.file.exceptions.FileDoesNotExistException;
import de.alpharogroup.file.exceptions.FileIsADirectoryException;
import de.alpharogroup.file.rename.RenameFileExtensions;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenameFileQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(RenameFileQuietlyExtensions.class);

    public static boolean forceToMoveFileQuietly(File srcFile, File destinationFile) {
        boolean moved = false;
        try {
            moved = RenameFileExtensions.forceToMoveFile(srcFile, destinationFile);
        }
        catch (IOException e) {
            log.error("forceToMoveFile method failed...\n" + e.getMessage(), (Throwable)e);
        }
        catch (FileIsADirectoryException e) {
            log.error("forceToMoveFile method failed...\n" + e.getMessage(), (Throwable)e);
        }
        return moved;
    }

    public static boolean renameFileQuietly(File fileToRename, File newFileName, boolean delete) {
        boolean success = fileToRename.renameTo(newFileName);
        if (!success) {
            log.info("The file " + fileToRename.getName() + " was not renamed.");
            if (delete) {
                log.info("Try to copy the content into the new file with the new name.");
                try {
                    boolean copied = CopyFileExtensions.copyFile(fileToRename, newFileName);
                    if (copied) {
                        log.info("Sucessfully copied the old file " + fileToRename.getName() + " to the new file " + newFileName.getName() + ".");
                    } else {
                        log.info("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                    }
                }
                catch (IOException e) {
                    log.error("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                }
                catch (FileIsADirectoryException e) {
                    log.error("Given file " + newFileName.getName() + " is a directory.", (Throwable)e);
                }
                log.info("Try to delete the old file " + fileToRename.getName() + ".");
                try {
                    DeleteFileExtensions.delete(fileToRename);
                    success = true;
                }
                catch (IOException e) {
                    log.error("Try to delete the old file " + fileToRename.getName() + " failed.", (Throwable)e);
                }
            }
        }
        return success;
    }

    public static boolean renameFileQuietly(File fileToRename, String newFileNameWithoutAbsolutPath) {
        boolean renamed = false;
        try {
            renamed = RenameFileExtensions.renameFile(fileToRename, newFileNameWithoutAbsolutPath);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (FileIsADirectoryException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (FileDoesNotExistException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return renamed;
    }

    private RenameFileQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

