/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.csv;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.array.ArrayExtensions;
import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.collections.list.ListFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsvBean
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1648936246997896598L;
    private String[] columnTypes;
    private String[] columnTypesEdit;
    private String[] headers;
    private Map<Integer, Integer> lineOrder;
    private List<String[]> lines;

    public CsvBean(String[] headers, String[] columnTypes, List<String[]> lines) {
        this.headers = headers;
        this.columnTypes = columnTypes;
        this.lines = lines;
    }

    public CsvBean(String[] headers, String[] columnTypes, String[] columnTypesEdit, List<String[]> lines) {
        this.headers = headers;
        this.columnTypes = columnTypes;
        this.columnTypesEdit = columnTypesEdit;
        this.lines = lines;
    }

    public Object clone() {
        CsvBean inst = CsvBean.builder().columnTypes((String[])ArrayExtensions.arraycopyWithSystem((Object[])this.columnTypes, this.columnTypes == null ? null : new String[this.columnTypes.length])).columnTypesEdit((String[])ArrayExtensions.arraycopyWithSystem((Object[])this.columnTypesEdit, this.columnTypesEdit == null ? null : new String[this.columnTypesEdit.length])).headers((String[])ArrayExtensions.arraycopyWithSystem((Object[])this.headers, this.headers == null ? null : new String[this.headers.length])).lineOrder((Map<Integer, Integer>)(this.lineOrder == null ? null : new LinkedHashMap<Integer, Integer>(this.lineOrder))).lines(this.lines == null ? null : ListFactory.newArrayList(this.lines, (Object[])new String[0][])).build();
        return inst;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CsvBean other = (CsvBean)o;
        boolean headersEquality = Arrays.equals(this.headers, other.headers);
        boolean columnTypesEquality = Arrays.equals(this.columnTypes, other.columnTypes);
        boolean linesEquality = false;
        if (this.lines == null && other.lines != null) {
            return false;
        }
        linesEquality = ListExtensions.isEqualListOfArrays(this.lines, other.lines);
        return headersEquality && columnTypesEquality && linesEquality;
    }

    public int hashCode() {
        int hashCode = 1;
        int prime = 31;
        hashCode = 31 * hashCode + Arrays.hashCode(this.columnTypes);
        hashCode = 31 * hashCode + Arrays.hashCode(this.headers);
        hashCode = 31 * hashCode * CollectionExtensions.hashCode(this.lines);
        return hashCode;
    }

    public static CsvBeanBuilder builder() {
        return new CsvBeanBuilder();
    }

    public CsvBeanBuilder toBuilder() {
        return new CsvBeanBuilder().columnTypes(this.columnTypes).columnTypesEdit(this.columnTypesEdit).headers(this.headers).lineOrder(this.lineOrder).lines(this.lines);
    }

    public String[] getColumnTypes() {
        return this.columnTypes;
    }

    public String[] getColumnTypesEdit() {
        return this.columnTypesEdit;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Map<Integer, Integer> getLineOrder() {
        return this.lineOrder;
    }

    public List<String[]> getLines() {
        return this.lines;
    }

    public void setColumnTypes(String[] columnTypes) {
        this.columnTypes = columnTypes;
    }

    public void setColumnTypesEdit(String[] columnTypesEdit) {
        this.columnTypesEdit = columnTypesEdit;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public void setLineOrder(Map<Integer, Integer> lineOrder) {
        this.lineOrder = lineOrder;
    }

    public void setLines(List<String[]> lines) {
        this.lines = lines;
    }

    public String toString() {
        return "CsvBean(columnTypes=" + Arrays.deepToString(this.getColumnTypes()) + ", columnTypesEdit=" + Arrays.deepToString(this.getColumnTypesEdit()) + ", headers=" + Arrays.deepToString(this.getHeaders()) + ", lineOrder=" + this.getLineOrder() + ", lines=" + this.getLines() + ")";
    }

    public CsvBean() {
    }

    public CsvBean(String[] columnTypes, String[] columnTypesEdit, String[] headers, Map<Integer, Integer> lineOrder, List<String[]> lines) {
        this.columnTypes = columnTypes;
        this.columnTypesEdit = columnTypesEdit;
        this.headers = headers;
        this.lineOrder = lineOrder;
        this.lines = lines;
    }

    public static class CsvBeanBuilder {
        private String[] columnTypes;
        private String[] columnTypesEdit;
        private String[] headers;
        private Map<Integer, Integer> lineOrder;
        private List<String[]> lines;

        CsvBeanBuilder() {
        }

        public CsvBeanBuilder columnTypes(String[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public CsvBeanBuilder columnTypesEdit(String[] columnTypesEdit) {
            this.columnTypesEdit = columnTypesEdit;
            return this;
        }

        public CsvBeanBuilder headers(String[] headers) {
            this.headers = headers;
            return this;
        }

        public CsvBeanBuilder lineOrder(Map<Integer, Integer> lineOrder) {
            this.lineOrder = lineOrder;
            return this;
        }

        public CsvBeanBuilder lines(List<String[]> lines) {
            this.lines = lines;
            return this;
        }

        public CsvBean build() {
            return new CsvBean(this.columnTypes, this.columnTypesEdit, this.headers, this.lineOrder, this.lines);
        }

        public String toString() {
            return "CsvBean.CsvBeanBuilder(columnTypes=" + Arrays.deepToString(this.columnTypes) + ", columnTypesEdit=" + Arrays.deepToString(this.columnTypesEdit) + ", headers=" + Arrays.deepToString(this.headers) + ", lineOrder=" + this.lineOrder + ", lines=" + this.lines + ")";
        }
    }
}

