/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.create;

import de.alpharogroup.file.create.CreateFileExtensions;
import de.alpharogroup.file.exceptions.DirectoryAllreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateFileQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(CreateFileQuietlyExtensions.class);

    public static boolean newDirectoriesQuietly(Collection<File> directories) {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileQuietlyExtensions.newDirectoryQuietly(dir);
        }
        return created;
    }

    public static boolean newDirectoryQuietly(File dir) {
        try {
            return CreateFileExtensions.newDirectory(dir);
        }
        catch (DirectoryAllreadyExistsException e) {
            log.error("Directory '" + dir.getAbsolutePath() + "' allready exists.", (Throwable)e);
            return false;
        }
    }

    public static boolean newFileQuietly(File file) {
        try {
            return CreateFileExtensions.newFile(file);
        }
        catch (IOException e) {
            log.error("File '" + file.getAbsolutePath() + "' could not created. For more information see the exception:", (Throwable)e);
            return false;
        }
    }

    private CreateFileQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

