/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.checksum;

import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.file.checksum.ChecksumExtensions;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksumQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(ChecksumQuietlyExtensions.class);

    public static String getChecksumQuietly(byte[] bytes, Algorithm algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getChecksumQuietly failed...\n" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getChecksumQuietly(byte[] bytes, String algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getChecksumQuietly failed...\n" + e.getMessage(), (Throwable)e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(Byte[] bytes, String algorithm) {
        try {
            return ChecksumExtensions.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getChecksumQuietly failed...\n" + e.getMessage(), (Throwable)e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(File file, Algorithm algorithm) {
        try {
            return ChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("getChecksumQuietly failed...\n" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("getChecksumQuietly failed...\n" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private ChecksumQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

