/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.zip.ZipExtensions;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzipper {
    private String password;
    private File toDir;
    private ZipFile zipFile;

    public Unzipper(ZipFile zipFile, File toDir) {
        this.zipFile = zipFile;
        this.toDir = toDir;
    }

    public void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        ZipExtensions.extractZipEntry(zipFile, target, toDirectory);
    }

    public void unzip() throws IOException {
        this.unzip(this.zipFile, this.toDir);
    }

    public void unzip(ZipFile zipFile, File toDir) throws IOException {
        ZipExtensions.unzip(zipFile, toDir);
    }

    public static UnzipperBuilder builder() {
        return new UnzipperBuilder();
    }

    public UnzipperBuilder toBuilder() {
        return new UnzipperBuilder().password(this.password).toDir(this.toDir).zipFile(this.zipFile);
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    public File getToDir() {
        return this.toDir;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public String toString() {
        return "Unzipper(password=" + this.getPassword() + ", toDir=" + this.getToDir() + ", zipFile=" + this.getZipFile() + ")";
    }

    public Unzipper() {
    }

    public Unzipper(String password, File toDir, ZipFile zipFile) {
        this.password = password;
        this.toDir = toDir;
        this.zipFile = zipFile;
    }

    public static class UnzipperBuilder {
        private String password;
        private File toDir;
        private ZipFile zipFile;

        UnzipperBuilder() {
        }

        @Deprecated
        public UnzipperBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UnzipperBuilder toDir(File toDir) {
            this.toDir = toDir;
            return this;
        }

        public UnzipperBuilder zipFile(ZipFile zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        public Unzipper build() {
            return new Unzipper(this.password, this.toDir, this.zipFile);
        }

        public String toString() {
            return "Unzipper.UnzipperBuilder(password=" + this.password + ", toDir=" + this.toDir + ", zipFile=" + this.zipFile + ")";
        }
    }
}

