/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.zip.ZipDecryptInputStream;
import de.alpharogroup.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Unzipper {
    private ZipFile zipFile;
    private File toDir;
    private String password;

    public Unzipper() {
    }

    public Unzipper(ZipFile zipFile, File toDir) {
        this.zipFile = zipFile;
        this.toDir = toDir;
    }

    public void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        File fileToExtract = new File(toDirectory, target.getName());
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        InputStream is = null;
        try {
            is = zipFile.getInputStream(target);
            if (is != null) {
                int c;
                bis = new BufferedInputStream(is);
                new File(fileToExtract.getParent()).mkdirs();
                bos = new BufferedOutputStream(new FileOutputStream(fileToExtract));
                while ((c = bis.read()) != -1) {
                    bos.write((byte)c);
                }
                bos.close();
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamExtensions.closeInputStream((InputStream)is);
                StreamExtensions.closeInputStream(bis);
                StreamExtensions.closeOutputStream(bos);
                throw throwable;
            }
        }
        StreamExtensions.closeInputStream((InputStream)is);
        StreamExtensions.closeInputStream((InputStream)bis);
        StreamExtensions.closeOutputStream(bos);
    }

    public String getPassword() {
        return this.password;
    }

    public File getToDir() {
        return this.toDir;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public void unzip() throws IOException {
        this.unzip(this.zipFile, this.toDir);
    }

    public void unzip(File zipFile, File toDir, String password) throws IOException {
        this.unzip(zipFile, toDir, password, null);
    }

    public void unzip(File zipFile, File toDir, String password, Charset charsetName) throws IOException {
        ZipEntry ze;
        FileInputStream fis = new FileInputStream(zipFile);
        ZipDecryptInputStream zdis = new ZipDecryptInputStream(fis, password);
        ZipInputStream zis = null;
        zis = charsetName != null ? new ZipInputStream((InputStream)zdis, charsetName) : new ZipInputStream(zdis);
        while ((ze = zis.getNextEntry()) != null) {
            int b;
            String pathToExtract = toDir.getAbsolutePath() + File.separator + ze.getName();
            FileOutputStream fos = new FileOutputStream(pathToExtract);
            while ((b = zis.read()) != -1) {
                fos.write(b);
            }
            fos.close();
            zis.closeEntry();
        }
        zis.close();
    }

    public void unzip(ZipFile zipFile, File toDir) throws IOException {
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            this.extractZipEntry(zipFile, entry, toDir);
        }
        zipFile.close();
    }
}

