/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.create;

import de.alpharogroup.file.exceptions.DirectoryAllreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class CreateFileExtensions {
    private static final Logger logger = Logger.getLogger((String)CreateFileExtensions.class.getName());

    public static boolean newDirectories(Collection<File> directories) throws DirectoryAllreadyExistsException {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileExtensions.newDirectory(dir);
        }
        return created;
    }

    public static boolean newDirectoriesQuietly(Collection<File> directories) {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileExtensions.newDirectoryQuietly(dir);
        }
        return created;
    }

    public static boolean newDirectory(File dir) throws DirectoryAllreadyExistsException {
        boolean created = false;
        if (dir.exists()) {
            throw new DirectoryAllreadyExistsException("Directory allready exists.");
        }
        created = dir.mkdir();
        return created;
    }

    public static boolean newDirectoryQuietly(File dir) {
        try {
            return CreateFileExtensions.newDirectory(dir);
        }
        catch (DirectoryAllreadyExistsException e) {
            logger.error((Object)("Directory '" + dir.getAbsolutePath() + "' allready exists."), (Throwable)e);
            return false;
        }
    }

    public static boolean newFile(File file) throws IOException {
        boolean created = false;
        if (!file.exists()) {
            CreateFileExtensions.newParentDirectories(file);
            created = file.createNewFile();
        } else {
            created = true;
        }
        return created;
    }

    public static boolean newFileQuietly(File file) {
        try {
            return CreateFileExtensions.newFile(file);
        }
        catch (IOException e) {
            logger.error((Object)("File '" + file.getAbsolutePath() + "' could not created. For more information see the exception:"), (Throwable)e);
            return false;
        }
    }

    public static boolean newFiles(Collection<File> files) throws IOException {
        boolean created = false;
        for (File file : files) {
            created = CreateFileExtensions.newFile(file);
        }
        return created;
    }

    public static void newParentDirectories(File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    private CreateFileExtensions() {
    }
}

