/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider.util;

import de.agilecoders.wicket.extensions.slider.ISliderValue;

public class LongRangeValue
implements ISliderValue {
    private long min;
    private long max;

    public LongRangeValue() {
    }

    public LongRangeValue(long min, long max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ISliderValue fromString(String value) {
        String toParser = value.indexOf(91) >= 0 ? value.substring(1, value.length() - 1) : value;
        String[] values = toParser.split(",");
        return new LongRangeValue(Long.parseLong(values[0]), Long.parseLong(values[1]));
    }

    @Override
    public Class<? extends Number> getNumberType() {
        return Long.class;
    }

    @Override
    public String toString() {
        return "[" + this.min + "," + this.max + "]";
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongRangeValue)) {
            return false;
        }
        LongRangeValue that = (LongRangeValue)o;
        if (this.max != that.max) {
            return false;
        }
        return this.min == that.min;
    }

    public int hashCode() {
        int result = (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        return result;
    }
}

