/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.spinner;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.spinner.SpinnerConfig;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spinner<T extends Number>
extends TextField<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Spinner.class);
    private static final CssResourceReference SPINNER_CSS = new CssResourceReference(Spinner.class, "css/touchspin.min.css");
    private static final JavaScriptResourceReference SPINNER_JS = new JavaScriptResourceReference(Spinner.class, "js/touchspin.min.js");
    private final SpinnerConfig config;

    public Spinner(String id) {
        this(id, null, new SpinnerConfig());
    }

    public Spinner(String id, SpinnerConfig config) {
        this(id, null, config);
    }

    public Spinner(String id, IModel<T> model) {
        this(id, model, new SpinnerConfig());
    }

    public Spinner(String id, IModel<T> model, SpinnerConfig config) {
        super(id, model);
        Args.notNull((Object)((Object)config), (String)"config");
        this.config = config;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)SPINNER_CSS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SPINNER_JS));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.getConfig())));
    }

    protected void onInitialize() {
        if (this.wantStartNotification()) {
            this.registerStartListener();
        }
        if (this.wantStartUpNotification()) {
            this.registerStartUpListener();
        }
        if (this.wantStartDownNotification()) {
            this.registerStartDownListener();
        }
        if (this.wantStopNotification()) {
            this.registerStopListener();
        }
        if (this.wantStopUpNotification()) {
            this.registerStopUpListener();
        }
        if (this.wantStopDownNotification()) {
            this.registerStopDownListener();
        }
        if (this.wantMinNotification()) {
            this.registerMinListener();
        }
        if (this.wantMaxNotification()) {
            this.registerMaxListener();
        }
        super.onInitialize();
    }

    private void registerStartListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.startspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Start spin");
                Spinner.this.onStartSpin(target);
            }
        }});
    }

    protected boolean wantStartNotification() {
        return false;
    }

    private void registerStartUpListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.startupspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Start up spin");
                Spinner.this.onStartUpSpin(target);
            }
        }});
    }

    protected boolean wantStartUpNotification() {
        return false;
    }

    private void registerStartDownListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.startdownspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Start down spin");
                Spinner.this.onStartDownSpin(target);
            }
        }});
    }

    protected boolean wantStartDownNotification() {
        return false;
    }

    private void registerStopListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.stopspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Stop spin");
                Spinner.this.onStopSpin(target);
            }
        }});
    }

    protected boolean wantStopNotification() {
        return false;
    }

    private void registerStopUpListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.stopupspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Stop up spin");
                Spinner.this.onStopUpSpin(target);
            }
        }});
    }

    protected boolean wantStopUpNotification() {
        return false;
    }

    private void registerStopDownListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.stopdownspin"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Stop down spin");
                Spinner.this.onStopDownSpin(target);
            }
        }});
    }

    protected boolean wantStopDownNotification() {
        return false;
    }

    private void registerMinListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.min"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Reached minimum value");
                Spinner.this.onMin(target);
            }
        }});
    }

    protected boolean wantMinNotification() {
        return false;
    }

    private void registerMaxListener() {
        this.add(new Behavior[]{new AjaxEventBehavior("touchspin.on.max"){

            protected void onEvent(AjaxRequestTarget target) {
                LOG.debug("Reached maximum value");
                Spinner.this.onMax(target);
            }
        }});
    }

    protected boolean wantMaxNotification() {
        return false;
    }

    protected void onMax(AjaxRequestTarget target) {
    }

    protected void onMin(AjaxRequestTarget target) {
    }

    protected void onStopDownSpin(AjaxRequestTarget target) {
    }

    protected void onStopUpSpin(AjaxRequestTarget target) {
    }

    protected void onStopSpin(AjaxRequestTarget target) {
    }

    protected void onStartDownSpin(AjaxRequestTarget target) {
    }

    protected void onStartSpin(AjaxRequestTarget target) {
    }

    protected void onStartUpSpin(AjaxRequestTarget target) {
    }

    protected CharSequence createScript(SpinnerConfig config) {
        return JQuery.$((Component)this).chain((CharSequence)"TouchSpin", (Config)config, new Config[0]).get();
    }

    public SpinnerConfig getConfig() {
        return this.config;
    }
}

