/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.extensions.tour;

import de.agilecoders.wicket.markup.html.bootstrap.extensions.tour.BootstrapTourJsReference;
import de.agilecoders.wicket.markup.html.bootstrap.extensions.tour.TourStep;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class TourBehavior
extends Behavior {
    private final List<TourStep> steps = new ArrayList<TourStep>();

    public TourBehavior addStep(TourStep step) {
        Args.notNull((Object)((Object)step), (String)"step");
        this.steps.add(step);
        return this;
    }

    public final int size() {
        return this.steps.size();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.steps.size() > 0) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapTourJsReference.INSTANCE));
            StringBuilder js = new StringBuilder();
            js.append("(function() { var tour = new Tour();");
            for (TourStep step : this.steps) {
                js.append("tour.addStep(").append(step.toJsonString()).append(");");
            }
            js.append("tour.start();");
            js.append(this.createExtraConfig());
            js.append("})()");
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)js));
        }
    }

    protected CharSequence createExtraConfig() {
        return "";
    }
}

